/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.member;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class PromoteCommand
extends CommandBase {
    public PromoteCommand(KingdomCraftImpl kdc) {
        super(kdc, "promote", 1);
        this.setArgumentsHint("<player>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdPromoteExplanation"));
        this.setPermissions("kingdom.promote", "kingdom.promote.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            if (player.hasPermission("kingdom.promote.other")) {
                return this.kdc.getOnlinePlayers().stream().filter(p -> this.kdc.getUser((PlatformPlayer)p).getKingdom() != null).map(PlatformPlayer::getName).collect(Collectors.toList());
            }
            User user = this.kdc.getUser(player);
            if (player.hasPermission("kingdom.promote") && user.getKingdom() != null) {
                return this.kdc.getOnlinePlayers().stream().filter(p -> this.kdc.getUser((PlatformPlayer)p).getKingdom() == user.getKingdom()).filter(p -> {
                    User u = this.kdc.getUser((PlatformPlayer)p);
                    return u.getRank() == null || u.getRank().getLevel() < user.getRank().getLevel();
                }).map(PlatformPlayer::getName).collect(Collectors.toList());
            }
            return null;
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        this.kdc.getPlugin().getScheduler().executeAsync(() -> {
            try {
                Rank rank;
                User target = this.kdc.getUser(args[0]).get();
                if (target == null) {
                    this.kdc.getMessages().send(sender, "cmdErrorPlayerNotExist", args[0]);
                    return;
                }
                Kingdom kingdom = target.getKingdom();
                if (kingdom == null) {
                    this.kdc.getMessages().send(sender, "cmdErrorTargetNoKingdom", target.getName());
                    return;
                }
                List ranks = kingdom.getRanks().stream().sorted(Comparator.comparingInt(Rank::getLevel).thenComparing(Rank::getName)).collect(Collectors.toList());
                int index = ranks.indexOf(target.getRank());
                if (index == -1) {
                    rank = kingdom.getDefaultRank() != null ? kingdom.getDefaultRank() : (Rank)ranks.get(0);
                } else {
                    if (index == ranks.size() - 1) {
                        this.kdc.getMessages().send(sender, "cmdPromoteHighest", new String[0]);
                        return;
                    }
                    rank = (Rank)ranks.get(index + 1);
                }
                if (!sender.hasPermission("kingdom.promote.other")) {
                    User user = this.kdc.getUser((PlatformPlayer)sender);
                    if (user.getKingdom() != kingdom) {
                        this.kdc.getMessages().send(sender, "cmdErrorNoPermission", new String[0]);
                        return;
                    }
                    if (user.getRank() == null || user.getRank().getLevel() <= rank.getLevel()) {
                        this.kdc.getMessages().send(sender, "cmdSetRankLowLevelTarget", rank.getName());
                        return;
                    }
                    if (target.getRank() != null && user.getRank().getLevel() <= target.getRank().getLevel()) {
                        this.kdc.getMessages().send(sender, "cmdSetRankLowLevelCurrent", target.getName());
                        return;
                    }
                }
                if (!sender.hasPermission("kingdom.promote.other") && rank.getMaxMembers() > 0 && rank.getMaxMembers() <= rank.getMemberCount()) {
                    this.kdc.getMessages().send(sender, "cmdSetRankFull", rank.getName());
                    return;
                }
                target.setRank(rank);
                this.kdc.saveAsync(target);
                PlatformPlayer targetPlayer = this.kdc.getPlayer(target);
                if (targetPlayer != null) {
                    this.kdc.getMessages().send((PlatformSender)targetPlayer, "cmdSetRankTarget", rank.getName());
                }
                this.kdc.getMessages().send(sender, "cmdSetRankSender", target.getName(), rank.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

