/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.member;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;

public class LeaveCommand
extends CommandBase {
    public LeaveCommand(KingdomCraftImpl kdc) {
        super(kdc, "leave", 0, true);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdLeaveExplanation"));
        this.setPermissions("kingdom.leave");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        if (user.getKingdom() == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Kingdom oldKingdom = user.getKingdom();
        user.setKingdom(null);
        this.kdc.saveAsync(user);
        this.kdc.getMessages().send(sender, "cmdLeave", oldKingdom.getName());
        for (PlatformPlayer member : this.kdc.getOnlinePlayers()) {
            if (this.kdc.getUser(member).getKingdom() != oldKingdom) continue;
            this.kdc.getMessages().send((PlatformSender)member, "cmdLeaveMembers", user.getName());
        }
    }
}

