/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.member;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class KickCommand
extends CommandBase {
    public KickCommand(KingdomCraftImpl kdc) {
        super(kdc, "kick", 1);
        this.setArgumentsHint("<player>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdKickExplanation"));
        this.setPermissions("kingdom.kick", "kingdom.kick.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            if (player.hasPermission("kingdom.kick.other")) {
                return this.kdc.getOnlinePlayers().stream().filter(p -> p != player).map(PlatformPlayer::getName).collect(Collectors.toList());
            }
            User user = this.kdc.getUser(player);
            if (player.hasPermission("kingdom.kick") && user.getKingdom() != null) {
                return this.kdc.getOnlinePlayers().stream().filter(p -> this.kdc.getUser((PlatformPlayer)p).getKingdom() == user.getKingdom()).map(PlatformPlayer::getName).collect(Collectors.toList());
            }
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        this.kdc.getPlugin().getScheduler().executeAsync(() -> {
            try {
                User target = this.kdc.getUser(args[0]).get();
                if (target == null) {
                    this.kdc.getMessages().send(sender, "cmdErrorPlayerNotExist", args[0]);
                    return;
                }
                Kingdom kingdom = target.getKingdom();
                if (kingdom == null) {
                    this.kdc.getMessages().send(sender, "cmdErrorTargetNoKingdom", target.getName());
                    return;
                }
                if (sender instanceof PlatformPlayer) {
                    User user = this.kdc.getUser((PlatformPlayer)sender);
                    if (!sender.hasPermission("kingdom.kick.other")) {
                        if (kingdom != user.getKingdom()) {
                            this.kdc.getMessages().send(sender, "cmdErrorNoPermission", new String[0]);
                            return;
                        }
                        if (user.getRank() == null || target.getRank() != null && user.getRank().getLevel() <= target.getRank().getLevel()) {
                            this.kdc.getMessages().send(sender, "cmdKickLowLevel", target.getName());
                            return;
                        }
                    }
                }
                target.setKingdom(null);
                this.kdc.saveAsync(target);
                PlatformPlayer targetPlayer = this.kdc.getPlayer(target);
                if (targetPlayer != null) {
                    this.kdc.getMessages().send((PlatformSender)targetPlayer, "cmdKickTarget", kingdom.getName());
                }
                this.kdc.getMessages().send(sender, "cmdKickSender", target.getName(), kingdom.getName());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }
}

