/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.member;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.KingdomInvite;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class InviteCommand
extends CommandBase {
    public InviteCommand(KingdomCraftImpl kdc) {
        super(kdc, "invite", 1, true);
        this.setArgumentsHint("<player>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdInviteExplanation"));
        this.setPermissions("kingdom.invite");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        User user;
        Kingdom kingdom;
        if (args.length == 1 && (kingdom = (user = this.kdc.getUser(player)).getKingdom()) != null) {
            return this.kdc.getOnlinePlayers().stream().filter(p -> p != player).filter(p -> {
                User pu = this.kdc.getUser((PlatformPlayer)p);
                return pu.getKingdom() == null || pu.getKingdom() != kingdom;
            }).map(PlatformPlayer::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        if (user.getKingdom() == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        this.kdc.getPlugin().getScheduler().executeAsync(() -> {
            try {
                User target = this.kdc.getUser(args[0]).get();
                if (target == null) {
                    this.kdc.getMessages().send(sender, "cmdErrorPlayerNotExist", args[0]);
                    return;
                }
                if (target.getKingdom() == user.getKingdom()) {
                    this.kdc.getMessages().send(sender, "cmdInviteAlreadyKingdom", target.getName());
                    return;
                }
                KingdomInvite invite = target.getInvite(user.getKingdom());
                if (invite != null && invite.isValid() && invite.getSender().equals(user)) {
                    this.kdc.getMessages().send(sender, "cmdInviteAlready", target.getName());
                    return;
                }
                if (invite != null) {
                    this.kdc.deleteAsync(invite);
                }
                invite = target.addInvite(user);
                this.kdc.saveAsync(invite);
                PlatformPlayer targetPlayer = this.kdc.getPlayer(target);
                if (targetPlayer != null) {
                    this.kdc.getMessages().send((PlatformSender)targetPlayer, "cmdInviteTarget", user.getName(), user.getKingdom().getName());
                }
                this.kdc.getMessages().send(sender, "cmdInviteSender", target.getName(), user.getKingdom().getName());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }
}

