/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.member;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.Set;
import java.util.stream.Collectors;

public class BroadcastOtherCommand
extends CommandBase {
    public BroadcastOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "broadcast", 2);
        this.setArgumentsHint("<kingdom> <message>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdBroadcastExplanation"));
        this.setPermissions("kingdom.broadcast.other");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null || kingdom.isTemplate()) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        Set<PlatformSender> target = this.kdc.getOnlinePlayers().stream().filter(p -> p.getUser().getKingdom() == kingdom).collect(Collectors.toSet());
        target.add(sender);
        String msg = this.kdc.getMessages().colorify(args[1]);
        target.forEach(p -> this.kdc.getMessages().send((PlatformSender)p, "cmdBroadcast", msg));
    }
}

