/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.member;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.Set;
import java.util.stream.Collectors;

public class BroadcastCommand
extends CommandBase {
    public BroadcastCommand(KingdomCraftImpl kdc) {
        super(kdc, "broadcast", 1, true);
        this.setArgumentsHint("<message>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdBroadcastExplanation"));
        this.setPermissions("kingdom.broadcast");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = ((PlatformPlayer)sender).getUser().getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Set<PlatformSender> target = this.kdc.getOnlinePlayers().stream().filter(p -> p.getUser().getKingdom() == kingdom).collect(Collectors.toSet());
        target.add(sender);
        String msg = this.kdc.getMessages().colorify(args[0]);
        target.forEach(p -> this.kdc.getMessages().send((PlatformSender)p, "cmdBroadcast", msg));
    }
}

