/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.general;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ListCommand
extends CommandBase {
    public ListCommand(KingdomCraftImpl kdc) {
        super(kdc, "list", 0);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdListExplanation"));
        this.setPermissions("kingdom.list");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        List kingdoms = this.kdc.getKingdoms().stream().sorted(Comparator.comparing(Kingdom::isInviteOnly)).map(Kingdom::getName).collect(Collectors.toList());
        String delimiter = this.kdc.getMessages().getMessage("cmdListDelimiter");
        delimiter = delimiter != null ? delimiter : "&a, &2";
        String result = String.join((CharSequence)delimiter, kingdoms);
        this.kdc.getMessages().send(sender, "cmdList", result);
    }
}

