/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.general;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.KingdomInvite;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class JoinCommand
extends CommandBase {
    public JoinCommand(KingdomCraftImpl kdc) {
        super(kdc, "join", 1, true);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdJoinExplanation"));
        this.setPermissions("kingdom.join");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        KingdomInvite invite;
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null || kingdom.isTemplate()) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        User user = this.kdc.getUser((PlatformPlayer)sender);
        if (user.getKingdom() != null) {
            this.kdc.getMessages().send(sender, "cmdJoinAlready", new String[0]);
            return;
        }
        if (!(!kingdom.isInviteOnly() || sender.hasPermission("kingdom.join." + kingdom.getName().toLowerCase()) || (invite = user.getInvite(kingdom)) != null && invite.isValid())) {
            this.kdc.getMessages().send(sender, "cmdJoinNoInvite", kingdom.getName());
            this.kdc.getOnlinePlayers().stream().filter(p -> p.getUser().getKingdom() == kingdom).filter(p -> p.hasPermission("kingdom.invite")).filter(p -> !p.has("INVITE_MEMBER_" + user.getName()) || p.get("INVITE_MEMBER_" + user.getName(), Long.class) < System.currentTimeMillis()).forEach(p -> {
                p.set("INVITE_MEMBER_" + user.getName(), System.currentTimeMillis() + 15000L);
                this.kdc.getMessages().send((PlatformSender)p, "cmdJoinNoInviteMembers", user.getName());
            });
            return;
        }
        if (kingdom.getMaxMembers() > 0 && kingdom.getMaxMembers() <= kingdom.getMemberCount()) {
            this.kdc.getMessages().send(sender, "cmdJoinFull", kingdom.getName());
            return;
        }
        if (kingdom.getDefaultRank() != null && kingdom.getDefaultRank().getMaxMembers() > 0 && kingdom.getDefaultRank().getMaxMembers() <= kingdom.getDefaultRank().getMemberCount()) {
            this.kdc.getMessages().send(sender, "cmdJoinFull", kingdom.getName());
            return;
        }
        user.setKingdom(kingdom);
        ((CompletableFuture)this.kdc.saveAsync(user).thenRun(user::clearInvites)).exceptionally(ex -> {
            this.kdc.getPlugin().log(ex.getMessage(), Level.SEVERE);
            return null;
        });
        this.kdc.getMessages().send(sender, "cmdJoin", kingdom.getName());
        for (PlatformPlayer p2 : this.kdc.getOnlinePlayers()) {
            if (p2.equals(sender) || this.kdc.getUser(p2).getKingdom() != kingdom) continue;
            this.kdc.getMessages().send((PlatformSender)p2, "cmdJoinMembers", user.getName());
        }
    }
}

