/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.general;

import com.gufli.kingdomcraft.api.commands.Command;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HelpCommand
extends CommandBase {
    private static final int pagesize = 6;

    public HelpCommand(KingdomCraftImpl kdc) {
        super(kdc, "help");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            List<Command> commands = this.getAvailableCommands(player);
            int totalpages = (int)Math.ceil((double)commands.size() * 1.0 / 6.0);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 1; i <= totalpages; ++i) {
                result.add(i + "");
            }
            return result;
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        int startindex;
        List<Command> commands = this.getAvailableCommands(sender);
        int totalpages = (int)Math.ceil((double)commands.size() * 1.0 / 6.0);
        int page = 1;
        if (args.length > 0 && args[0].matches("[0-9]+")) {
            page = Integer.parseInt(args[0]);
        }
        if (page > totalpages) {
            this.kdc.getMessages().send(sender, "cmdHelpPageLimit", totalpages + "");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.kdc.getMessages().getMessage("cmdHelpHeader"));
        sb.append("\n");
        String root = "kingdomcraft";
        if (this.kdc.getConfig().getCommandAliases().size() > 0) {
            root = this.kdc.getConfig().getCommandAliases().get(0);
        }
        for (int i = startindex = (page - 1) * 6; i < Math.min(commands.size(), startindex + 6); ++i) {
            Command cmd = commands.get(i);
            String command = "/" + root + " " + cmd.getCommands().get(0) + (cmd.getArgumentsHint() == null ? "" : " " + cmd.getArgumentsHint());
            String explanation = cmd.getExplanationMessage();
            sb.append(this.kdc.getMessages().getMessage("cmdHelpFormat", command, explanation));
            sb.append("\n");
        }
        sb.append(this.kdc.getMessages().getMessage("cmdHelpFooter", page + "", totalpages + ""));
        sender.sendMessage(sb.toString());
    }

    private List<Command> getAvailableCommands(PlatformSender sender) {
        List<Command> commands = this.kdc.getCommandManager().getCommands().stream().filter(Command::hasExplanationMessage).collect(Collectors.toList());
        commands = sender instanceof PlatformPlayer ? commands.stream().filter(cmd -> this.hasAnyPermission(sender, (Command)cmd)).collect(Collectors.toList()) : commands.stream().filter(cmd -> !cmd.isPlayerOnly()).collect(Collectors.toList());
        return commands;
    }

    private boolean hasAnyPermission(PlatformSender sender, Command command) {
        if (command.getPermissions() == null || command.getPermissions().length == 0) {
            return true;
        }
        return Arrays.stream(command.getPermissions()).anyMatch(sender::hasPermission);
    }
}

