/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class RanksRenameOtherCommand
extends CommandBase {
    public RanksRenameOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks rename", 3);
        this.setArgumentsHint("<kingdom> <rank> <name>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksRenameOtherExplanation"));
        this.setPermissions("kingdom.ranks.rename.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            Kingdom kingdom = this.kdc.getKingdom(args[0]);
            if (kingdom == null) {
                return null;
            }
            return kingdom.getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[1]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[0]);
            return;
        }
        if (!args[2].matches("[a-zA-Z0-9]+")) {
            this.kdc.getMessages().send(sender, "cmdErrorNameInvalid", new String[0]);
            return;
        }
        if (kingdom.getRank(args[2]) != null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankAlreadyExists", args[2]);
            return;
        }
        String oldName = rank.getName();
        rank.renameTo(args[2]);
        this.kdc.saveAsync(rank);
        this.kdc.getMessages().send(sender, "cmdRanksRenameOther", oldName, rank.getName(), kingdom.getName());
    }
}

