/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class RanksListOtherCommand
extends CommandBase {
    public RanksListOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks list", 1);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksListOtherExplanation"));
        this.setPermissions("kingdom.ranks.list.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        String list = kingdom.getRanks().stream().sorted((o1, o2) -> o2.getLevel() - o1.getLevel()).map(Rank::getName).collect(Collectors.joining(", "));
        this.kdc.getMessages().send(sender, "cmdRanksListOther", kingdom.getName(), list);
    }
}

