/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.stream.Collectors;

public class RanksListCommand
extends CommandBase {
    public RanksListCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks list", 0, true);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksListExplanation"));
        this.setPermissions("kingdom.ranks.list");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        String list = kingdom.getRanks().stream().sorted((o1, o2) -> o2.getLevel() - o1.getLevel()).map(Rank::getName).collect(Collectors.joining(", "));
        this.kdc.getMessages().send(sender, "cmdRanksList", list);
    }
}

