/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class RanksEditSuffixOtherCommand
extends CommandBase {
    public RanksEditSuffixOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks edit suffix", 3);
        this.setArgumentsHint("<rank> <value>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksEditSuffixOtherExplanation"));
        this.setPermissions("kingdom.ranks.edit.suffix.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            Kingdom kingdom = this.kdc.getKingdom(args[0]);
            if (kingdom == null) {
                return null;
            }
            return kingdom.getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[1]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[1]);
            return;
        }
        rank.setSuffix(args[2]);
        this.kdc.saveAsync(rank);
        this.kdc.getMessages().send(sender, "cmdRanksEditOther", "suffix", rank.getName(), kingdom.getName(), args[2]);
    }
}

