/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class RanksEditMaxMembersCommand
extends CommandBase {
    public RanksEditMaxMembersCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks edit max-members", 2, true);
        this.setArgumentsHint("<rank> <amount>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksEditMaxMembersExplanation"));
        this.setPermissions("kingdom.ranks.edit.max-members");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            User user = this.kdc.getUser(player);
            if (user.getKingdom() == null) {
                return null;
            }
            return user.getKingdom().getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[0]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[0]);
            return;
        }
        if (!args[1].matches("[0-9]+")) {
            this.kdc.getMessages().send(sender, "errorInvalidNumber", args[1]);
            return;
        }
        rank.setMaxMembers(Integer.parseInt(args[1]));
        this.kdc.saveAsync(rank);
        this.kdc.getMessages().send(sender, "cmdRanksEdit", "max-members", rank.getName(), args[1]);
    }
}

