/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;

public class RanksDeleteOtherCommand
extends CommandBase {
    public RanksDeleteOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks delete", 2);
        this.setArgumentsHint("<kingdom> <rank>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksDeleteOtherExplanation"));
        this.setPermissions("kingdom.ranks.delete.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[1]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[1]);
            return;
        }
        if (kingdom.getDefaultRank().equals(rank)) {
            this.kdc.getMessages().send(sender, "cmdRanksDeleteOtherDefault", kingdom.getName());
        } else {
            this.kdc.getMessages().send(sender, "cmdRanksDeleteOther", rank.getName(), kingdom.getName());
        }
        this.kdc.deleteAsync(rank);
    }
}

