/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;

public class RanksDeleteCommand
extends CommandBase {
    public RanksDeleteCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks delete", 1, true);
        this.setArgumentsHint("<rank>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksDeleteExplanation"));
        this.setPermissions("kingdom.ranks.delete");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[0]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[0]);
            return;
        }
        if (kingdom.getDefaultRank().equals(rank)) {
            this.kdc.getMessages().send(sender, "cmdRanksDeleteDefault", new String[0]);
        } else {
            this.kdc.getMessages().send(sender, "cmdRanksDelete", rank.getName());
        }
        this.kdc.deleteAsync(rank);
    }
}

