/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class RanksCreateOtherCommand
extends CommandBase {
    public RanksCreateOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks create", 2);
        this.setArgumentsHint("<kingdom> <name>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksCreateOtherExplanation"));
        this.setPermissions("kingdom.ranks.create.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        if (!args[1].matches("[a-zA-Z0-9]+")) {
            this.kdc.getMessages().send(sender, "cmdErrorNameInvalid", new String[0]);
            return;
        }
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        if (kingdom.getRank(args[1]) != null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankAlreadyExists", args[1]);
            return;
        }
        Rank rank = kingdom.createRank(args[1]);
        if (kingdom.getDefaultRank() == null) {
            kingdom.setDefaultRank(rank);
        }
        this.kdc.saveAsync(rank).thenRun(() -> {
            if (kingdom.getDefaultRank() == rank) {
                this.kdc.saveAsync(kingdom);
            }
        });
        this.kdc.getMessages().send(sender, "cmdRanksCreateOther", rank.getName(), kingdom.getName());
    }
}

