/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;

public class RanksCreateCommand
extends CommandBase {
    public RanksCreateCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks create", 1, true);
        this.setArgumentsHint("<name>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksCreateExplanation"));
        this.setPermissions("kingdom.ranks.create");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        if (!args[0].matches("[a-zA-Z0-9]+") || args[0].length() > 24) {
            this.kdc.getMessages().send(sender, "cmdErrorInvalidName", new String[0]);
            return;
        }
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        if (kingdom.getRank(args[0]) != null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankAlreadyexists", args[0]);
            return;
        }
        Rank rank = kingdom.createRank(args[0]);
        if (kingdom.getDefaultRank() == null) {
            kingdom.setDefaultRank(rank);
        }
        this.kdc.saveAsync(rank).thenRun(() -> {
            if (kingdom.getDefaultRank() == rank) {
                this.kdc.saveAsync(kingdom);
            }
        });
        this.kdc.getMessages().send(sender, "cmdRanksCreate", rank.getName());
    }
}

