/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.ranks;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Model;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RanksCloneCommand
extends CommandBase {
    public RanksCloneCommand(KingdomCraftImpl kdc) {
        super(kdc, "ranks clone", -1, true);
        this.addCommand("ranks copy");
        this.setArgumentsHint("<from-kingdom> <to-kingdom> <rank>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRanksCloneExplanation"));
        this.setPermissions("kingdom.ranks.clone");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            Kingdom kingdom = this.kdc.getKingdom(args[0]);
            if (kingdom == null) {
                return null;
            }
            return this.kdc.getKingdoms().stream().filter(k -> k != kingdom).map(Kingdom::getName).collect(Collectors.toList());
        }
        if (args.length == 3) {
            Kingdom from = this.kdc.getKingdom(args[0]);
            if (from == null || this.kdc.getKingdom(args[1]) == null) {
                return null;
            }
            return from.getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        if (args.length < 2) {
            this.kdc.getMessages().send(sender, "cmdErrorInvalidUsage", "/k ranks clone " + this.getArgumentsHint());
            return;
        }
        Kingdom from = this.kdc.getKingdom(args[0]);
        if (from == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        Kingdom to = this.kdc.getKingdom(args[1]);
        if (to == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[1]);
            return;
        }
        ArrayList<Rank> ranks = new ArrayList<Rank>();
        if (args.length == 3) {
            Rank rank = from.getRank(args[2]);
            if (rank == null) {
                this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[2]);
                return;
            }
            ranks.add(rank);
        } else {
            ranks.addAll(from.getRanks());
        }
        ArrayList<Model> models = new ArrayList<Model>();
        for (Rank rank : ranks) {
            Rank clone = rank.clone(to, true);
            models.add(clone);
            models.addAll(clone.getPermissionGroups());
            models.addAll(clone.getAttributes());
        }
        this.kdc.saveAsync(models);
        if (ranks.size() == 1) {
            this.kdc.getMessages().send(sender, "cmdRanksClone", ((Rank)ranks.get(0)).getName(), from.getName(), to.getName());
        } else {
            this.kdc.getMessages().send(sender, "cmdRanksCloneMany", from.getName(), to.getName());
        }
    }
}

