/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class RenameOtherCommand
extends CommandBase {
    public RenameOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "rename", 2);
        this.setArgumentsHint("<kingdom> <name>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRenameOtherExplanation"));
        this.setPermissions("kingdom.rename.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null || kingdom.isTemplate()) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        if (!args[1].matches("[a-zA-Z0-9]+")) {
            this.kdc.getMessages().send(sender, "cmdErrorInvalidName", new String[0]);
            return;
        }
        if (this.kdc.getKingdom(args[1]) != null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomAlreadyExists", args[1]);
            return;
        }
        String oldName = kingdom.getName();
        kingdom.renameTo(args[1]);
        this.kdc.saveAsync(kingdom);
        this.kdc.getPlugin().getScheduler().executeSync(() -> this.kdc.getMessages().send(sender, "cmdRenameOther", oldName, kingdom.getName()));
    }
}

