/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class RenameCommand
extends CommandBase {
    public RenameCommand(KingdomCraftImpl kdc) {
        super(kdc, "rename", 1);
        this.setArgumentsHint("<name>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdRenameExplanation"));
        this.setPermissions("kingdom.rename");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        if (!args[0].matches("[a-zA-Z0-9]+")) {
            this.kdc.getMessages().send(sender, "cmdErrorInvalidName", new String[0]);
            return;
        }
        if (this.kdc.getKingdom(args[0]) != null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomAlreadyExists", args[1]);
            return;
        }
        kingdom.renameTo(args[0]);
        this.kdc.saveAsync(kingdom);
        this.kdc.getPlugin().getScheduler().executeSync(() -> this.kdc.getMessages().send(sender, "cmdRename", kingdom.getName()));
    }
}

