/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class EditPrefixOtherCommand
extends CommandBase {
    public EditPrefixOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "edit prefix", 2);
        this.setArgumentsHint("<kingdom> <prefix>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdExitPrefixOtherExplanation"));
        this.setPermissions("kingdom.edit.prefix.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms(true).stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        kingdom.setPrefix(args[1]);
        this.kdc.saveAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdEditOther", "prefix", kingdom.getName(), args[1]);
    }
}

