/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class EditMaxMembersOtherCommand
extends CommandBase {
    public EditMaxMembersOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "edit max-members", 2);
        this.setArgumentsHint("<kingdom> <amount>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdExitMaxMembersOtherExplanation"));
        this.setPermissions("kingdom.edit.max-members.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms(true).stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        if (!args[1].matches("[0-9]+")) {
            this.kdc.getMessages().send(sender, "errorInvalidNumber", args[1]);
            return;
        }
        kingdom.setMaxMembers(Integer.parseInt(args[1]));
        this.kdc.saveAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdEditOther", "max-members", kingdom.getName(), kingdom.getMaxMembers() + "");
    }
}

