/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;

public class EditMaxMembersCommand
extends CommandBase {
    public EditMaxMembersCommand(KingdomCraftImpl kdc) {
        super(kdc, "edit max-members", 1, true);
        this.setArgumentsHint("<amount>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdExitMaxMembersExplanation"));
        this.setPermissions("kingdom.edit.max-members");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        if (!args[0].matches("[0-9]+")) {
            this.kdc.getMessages().send(sender, "errorInvalidNumber", args[0]);
            return;
        }
        kingdom.setMaxMembers(Integer.parseInt(args[0]));
        this.kdc.saveAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdEdit", "max-members", kingdom.getMaxMembers() + "");
    }
}

