/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class EditInviteOnlyOtherCommand
extends CommandBase {
    public EditInviteOnlyOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "edit invite-only", 2);
        this.setArgumentsHint("<kingdom> [true/false]");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdInviteOnlyOtherExplanation"));
        this.setPermissions("kingdom.edit.invite-only.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms(true).stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return Arrays.asList("true", "false");
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        if (!args[1].equalsIgnoreCase("true") && !args[1].equalsIgnoreCase("false")) {
            this.kdc.getMessages().send(sender, "errorInvalidBoolean", args[1]);
            return;
        }
        kingdom.setInviteOnly(Boolean.parseBoolean(args[1]));
        this.kdc.saveAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdEditOther", "invite-only", kingdom.getName(), kingdom.isInviteOnly() + "");
    }
}

