/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.Arrays;
import java.util.List;

public class EditInviteOnlyCommand
extends CommandBase {
    public EditInviteOnlyCommand(KingdomCraftImpl kdc) {
        super(kdc, "edit invite-only", 1, true);
        this.setArgumentsHint("[true/false]");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdEditInviteOnlyExplanation"));
        this.setPermissions("kingdom.edit.invite-only");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("true", "false");
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        if (!args[0].equalsIgnoreCase("true") && !args[0].equalsIgnoreCase("false")) {
            this.kdc.getMessages().send(sender, "errorInvalidBoolean", args[0]);
            return;
        }
        kingdom.setInviteOnly(Boolean.parseBoolean(args[0]));
        this.kdc.saveAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdEdit", "invite-only", kingdom.isInviteOnly() + "");
    }
}

