/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class EditDefaultRankOtherCommand
extends CommandBase {
    public EditDefaultRankOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "edit defaultrank", 2);
        this.setArgumentsHint("<kingdom> <rank>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdEditDefaultRankOtherExplanation"));
        this.setPermissions("kingdom.edit.defaultrank.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms(true).stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            Kingdom kingdom = this.kdc.getKingdom(args[0]);
            if (kingdom == null) {
                return null;
            }
            return kingdom.getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[1]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[1]);
            return;
        }
        kingdom.setDefaultRank(rank);
        this.kdc.saveAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdEditOther", "default rank", kingdom.getName(), rank.getName());
    }
}

