/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class EditDefaultRankCommand
extends CommandBase {
    public EditDefaultRankCommand(KingdomCraftImpl kdc) {
        super(kdc, "edit defaultrank", 1, true);
        this.setArgumentsHint("<rank>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdEditDefaultRankExplanation"));
        this.setPermissions("kingdom.edit.defaultrank");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            User user = this.kdc.getUser(player);
            if (user.getKingdom() == null) {
                return null;
            }
            return user.getKingdom().getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[0]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[0]);
            return;
        }
        kingdom.setDefaultRank(rank);
        this.kdc.saveAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdEdit", "default rank", rank.getName());
    }
}

