/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;

public class DeleteOtherCommand
extends CommandBase {
    public static final String DELETE_KEY = "KINGDOM_DELETE_REQUEST";

    public DeleteOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "delete", 1);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdDeleteOtherExplanation"));
        this.setPermissions("kingdom.delete", "kingdom.delete.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user;
        if (sender instanceof PlatformPlayer && args[0].equalsIgnoreCase("confirm")) {
            PlatformPlayer player = (PlatformPlayer)sender;
            if (!player.has(DELETE_KEY)) {
                this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
                return;
            }
            DeleteRequest req = player.get(DELETE_KEY, DeleteRequest.class);
            if (System.currentTimeMillis() - req.timestamp > 60000L) {
                this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
                return;
            }
            this.delete(player, req.kingdom);
            player.remove(DELETE_KEY);
            return;
        }
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null || kingdom.isTemplate()) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        if (sender instanceof PlatformPlayer && (user = this.kdc.getUser((PlatformPlayer)sender)).getKingdom() != kingdom && !sender.hasPermission("kingdom.delete.other")) {
            this.kdc.getMessages().send(sender, "noPermission", new String[0]);
            return;
        }
        if (!(sender instanceof PlatformPlayer)) {
            this.delete(sender, kingdom);
        } else {
            ((PlatformPlayer)sender).set(DELETE_KEY, new DeleteRequest(kingdom));
            this.kdc.getMessages().send(sender, "cmdDeleteConfirm", kingdom.getName());
        }
    }

    private void delete(PlatformSender sender, Kingdom kingdom) {
        for (PlatformPlayer p : this.kdc.getOnlinePlayers()) {
            User user = this.kdc.getUser(p);
            if (user.getKingdom() != kingdom) continue;
            user.setKingdom(null);
            this.kdc.getMessages().send((PlatformSender)p, "cmdDeleteMembers", new String[0]);
        }
        this.kdc.deleteAsync(kingdom);
        this.kdc.getMessages().send(sender, "cmdDelete", kingdom.getName());
    }

    public static class DeleteRequest {
        final Kingdom kingdom;
        final long timestamp;

        public DeleteRequest(Kingdom kingdom) {
            this.kingdom = kingdom;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

