/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.DeleteOtherCommand;
import java.util.List;

public class DeleteCommand
extends CommandBase {
    public DeleteCommand(KingdomCraftImpl kdc) {
        super(kdc, "delete", 0, true);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdDeleteExplanation"));
        this.setPermissions("kingdom.delete");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer player = (PlatformPlayer)sender;
        User user = this.kdc.getUser(player);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        ((PlatformPlayer)sender).set("KINGDOM_DELETE_REQUEST", new DeleteOtherCommand.DeleteRequest(kingdom));
        this.kdc.getMessages().send(sender, "cmdDeleteConfirm", kingdom.getName());
    }
}

