/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.kingdom;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Model;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CreateCommand
extends CommandBase {
    public CreateCommand(KingdomCraftImpl kdc) {
        super(kdc, "create", 1);
        this.setArgumentsHint("<name>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdCreateExplanation"));
        this.setPermissions("kingdom.create", "kingdom.create.other");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        if (!args[0].matches("[a-zA-Z0-9]+") || args[0].length() > 24) {
            this.kdc.getMessages().send(sender, "cmdErrorInvalidName", new String[0]);
            return;
        }
        if (this.kdc.getKingdom(args[0]) != null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomAlreadyExists", args[0]);
            return;
        }
        if (sender instanceof PlatformPlayer && this.kdc.getUser((PlatformPlayer)sender).getKingdom() != null && !sender.hasPermission("kingdom.create.other")) {
            this.kdc.getMessages().send(sender, "cmdErrorNoPermission", new String[0]);
            return;
        }
        Kingdom template = this.kdc.getTemplateKingdom();
        CompletableFuture<Kingdom> kdf = this.kdc.createKingdom(args[0]);
        kdf.thenAccept(kingdom -> this.kdc.getMessages().send(sender, "cmdCreate", kingdom.getName()));
        CompletionStage tf = ((CompletableFuture)((CompletableFuture)kdf.thenCompose(kingdom -> {
            template.copyTo((Kingdom)kingdom, true);
            return this.kdc.saveAsync((Model)kingdom).thenApply(unused -> kingdom);
        })).thenCompose(kingdom -> {
            for (Rank rank : template.getRanks()) {
                rank.clone((Kingdom)kingdom, true);
            }
            return this.kdc.saveAsync(kingdom.getRanks()).thenApply(unused -> kingdom);
        })).thenCompose(kingdom -> {
            if (template.getDefaultRank() != null) {
                kingdom.setDefaultRank(kingdom.getRank(template.getDefaultRank().getName()));
            }
            return this.kdc.saveAsync((Model)kingdom).thenApply(unused -> kingdom);
        });
        if (!(sender instanceof PlatformPlayer)) {
            return;
        }
        User user = this.kdc.getUser((PlatformPlayer)sender);
        if (user.getKingdom() != null) {
            return;
        }
        ((CompletableFuture)tf).thenAccept(kingdom -> {
            user.setKingdom((Kingdom)kingdom);
            if (kingdom.getRanks().isEmpty()) {
                return;
            }
            user.setRank(kingdom.getRanks().stream().max(Comparator.comparingInt(Rank::getLevel)).orElse(null));
            this.kdc.saveAsync(user);
        });
    }
}

