/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.groups;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.RankPermissionGroup;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import com.gufli.kingdomcraft.common.permissions.PermissionGroup;
import java.util.List;
import java.util.stream.Collectors;

public class GroupsRemoveCommand
extends CommandBase {
    public GroupsRemoveCommand(KingdomCraftImpl kdc) {
        super(kdc, "groups remove", 2, true);
        this.setArgumentsHint("<rank> <group>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdGroupsRemoveExplanation"));
        this.setPermissions("kingdom.groups.remove");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            User user = this.kdc.getUser(player);
            if (user.getKingdom() == null) {
                return null;
            }
            return user.getKingdom().getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            User user = this.kdc.getUser(player);
            if (user.getKingdom() == null || user.getKingdom().getRank(args[0]) == null) {
                return null;
            }
            return user.getKingdom().getRank(args[0]).getPermissionGroups().stream().map(RankPermissionGroup::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[0]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[0]);
            return;
        }
        PermissionGroup group = this.kdc.getPermissionManager().getGroup(args[1]);
        if (group == null) {
            this.kdc.getMessages().send(sender, "cmdErrorPermissionGroupNotExist", args[1]);
            return;
        }
        RankPermissionGroup rpg = rank.getPermissionGroup(group.getName());
        if (rpg == null) {
            this.kdc.getMessages().send(sender, "cmdGroupsRemoveNotExist", group.getName(), rank.getName());
            return;
        }
        this.kdc.deleteAsync(rpg);
        this.kdc.getMessages().send(sender, "cmdGroupsRemove", group.getName(), rank.getName());
    }
}

