/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.groups;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import com.gufli.kingdomcraft.common.permissions.PermissionGroup;
import java.util.List;
import java.util.stream.Collectors;

public class GroupsListOtherCommand
extends CommandBase {
    public GroupsListOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "groups list", 2);
        this.setArgumentsHint("<kingdom> <rank>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdGroupsListOtherExplanation"));
        this.setPermissions("kingdom.groups.list.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            Kingdom kingdom = this.kdc.getKingdom(args[0]);
            if (kingdom == null) {
                return null;
            }
            return kingdom.getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[1]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[1]);
            return;
        }
        this.kdc.getMessages().send(sender, "cmdGroupsListOther", rank.getName(), kingdom.getName(), this.kdc.getPermissionManager().getGroups(rank).stream().map(PermissionGroup::getName).collect(Collectors.joining(", ")));
    }
}

