/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.groups;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import com.gufli.kingdomcraft.common.permissions.PermissionGroup;
import java.util.List;
import java.util.stream.Collectors;

public class GroupsListCommand
extends CommandBase {
    public GroupsListCommand(KingdomCraftImpl kdc) {
        super(kdc, "groups list", 1, true);
        this.setArgumentsHint("<rank>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdGroupsListExplanation"));
        this.setPermissions("kingdom.groups.list");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            User user = this.kdc.getUser(player);
            if (user.getKingdom() == null) {
                return null;
            }
            return user.getKingdom().getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[0]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[0]);
            return;
        }
        this.kdc.getMessages().send(sender, "cmdGroupsList", rank.getName(), this.kdc.getPermissionManager().getGroups(rank).stream().map(PermissionGroup::getName).collect(Collectors.joining(", ")));
    }
}

