/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.groups;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import com.gufli.kingdomcraft.common.permissions.PermissionGroup;
import java.util.List;
import java.util.stream.Collectors;

public class GroupsCommand
extends CommandBase {
    public GroupsCommand(KingdomCraftImpl kdc) {
        super(kdc, "groups", 0);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdGroupsExplanation"));
        this.setPermissions("kingdom.groups");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        List groups = this.kdc.getPermissionManager().getGroups().stream().map(PermissionGroup::getName).collect(Collectors.toList());
        String delimiter = this.kdc.getMessages().getMessage("cmdGroupsDelimiter");
        delimiter = delimiter != null ? delimiter : "&a, &2";
        String result = String.join((CharSequence)delimiter, groups);
        this.kdc.getMessages().send(sender, "cmdGroups", result);
    }
}

