/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.edit.groups;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.RankPermissionGroup;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import com.gufli.kingdomcraft.common.permissions.PermissionGroup;
import java.util.List;
import java.util.stream.Collectors;

public class GroupsAddOtherCommand
extends CommandBase {
    public GroupsAddOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "groups add", 3);
        this.setArgumentsHint("<kingdom> <rank> <group>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdGroupsAddOtherExplanation"));
        this.setPermissions("kingdom.groups.add.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            Kingdom kingdom = this.kdc.getKingdom(args[0]);
            if (kingdom == null) {
                return null;
            }
            return kingdom.getRanks().stream().map(Rank::getName).collect(Collectors.toList());
        }
        if (args.length == 3) {
            Kingdom kingdom = this.kdc.getKingdom(args[0]);
            if (kingdom == null || kingdom.getRank(args[1]) == null) {
                return null;
            }
            return this.kdc.getPermissionManager().getGroups().stream().map(PermissionGroup::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        Rank rank = kingdom.getRank(args[1]);
        if (rank == null) {
            this.kdc.getMessages().send(sender, "cmdErrorRankNotExist", args[1]);
            return;
        }
        PermissionGroup group = this.kdc.getPermissionManager().getGroup(args[2]);
        if (group == null) {
            this.kdc.getMessages().send(sender, "cmdErrorPermissionGroupNotExist", args[2]);
            return;
        }
        if (rank.getPermissionGroup(group.getName()) != null) {
            this.kdc.getMessages().send(sender, "cmdGroupsAddAlreadyExists", group.getName(), rank.getName());
            return;
        }
        RankPermissionGroup rpg = rank.createPermissionGroup(group.getName());
        this.kdc.saveAsync(rpg);
        this.kdc.getMessages().send(sender, "cmdGroupsAddOther", group.getName(), rank.getName(), kingdom.getName());
    }
}

