/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.chat;

import com.gufli.kingdomcraft.api.chat.ChatChannel;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultChatChannelCommand
extends CommandBase {
    public DefaultChatChannelCommand(KingdomCraftImpl kdc) {
        super(kdc, "defaultchatchannel", -1, true);
        this.setArgumentsHint("<chatchannel>");
        this.addCommand("defaultchannel");
        this.addCommand("dc");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdDefaultChatChannelExplanation"));
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        return this.kdc.getChatManager().getChatChannels().stream().filter(c -> this.kdc.getChatManager().canTalk(sender, (ChatChannel)c)).map(ChatChannel::getName).collect(Collectors.toList());
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer player = (PlatformPlayer)sender;
        if (args.length == 0) {
            player.remove("DEFAULT_CHATCHANNEL");
            this.kdc.getMessages().send(sender, "cmdDefaultChatChannelDisable", new String[0]);
            return;
        }
        ChatChannel cc = this.kdc.getChatManager().getChatChannel(args[0]);
        if (cc == null || !this.kdc.getChatManager().canTalk(player, cc)) {
            this.kdc.getMessages().send(sender, "cmdChatChannelNotExist", args[0]);
            return;
        }
        player.set("DEFAULT_CHATCHANNEL", cc.getName());
        this.kdc.getMessages().send(sender, "cmdDefaultChatChannel", cc.getName());
    }
}

