/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.chat;

import com.gufli.kingdomcraft.api.chat.ChatChannel;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ChatCommand
extends CommandBase {
    public ChatCommand(KingdomCraftImpl kdc) {
        super(kdc, "chat", -1, true);
        this.addCommand("c");
        this.setArgumentsHint("<channel> <message>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdChatExplanation"));
        this.setPermissions("kingdom.chat", "kingdom.chat.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            return this.kdc.getChatManager().getChatChannels().stream().filter(c -> player.hasPermission("kingdom.chat.other") || this.kdc.getChatManager().canTalk(player, (ChatChannel)c)).map(ChatChannel::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer player = (PlatformPlayer)sender;
        if (args.length < 2) {
            this.kdc.getMessages().send(sender, "cmdErrorInvalidUsage", "/k chat " + this.getArgumentsHint());
            return;
        }
        ChatChannel channel = this.kdc.getChatManager().getChatChannel(args[0]);
        if (channel == null) {
            this.kdc.getMessages().send(sender, "cmdChatNoChannel", args[0]);
            return;
        }
        if (!channel.isEnabled()) {
            this.kdc.getMessages().send(sender, "cmdChatDisabled", args[0]);
            return;
        }
        if (!this.kdc.getChatManager().canTalk(player, channel) && !player.hasPermission("kingdom.chat.other")) {
            this.kdc.getMessages().send(sender, "cmdErrorNoPermission", new String[0]);
            return;
        }
        String msg = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        String stripped = this.kdc.getMessages().decolorify(this.kdc.getMessages().colorify(msg)).trim();
        if (stripped.equals("")) {
            this.kdc.getMessages().send(sender, "cmdChatEmptyMessage", new String[0]);
            return;
        }
        this.kdc.getChatManager().dispatch(player, channel, msg);
    }
}

