/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.chat;

import com.gufli.kingdomcraft.api.chat.ChatChannel;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.domain.UserChatChannel;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class ChatChannelJoinCommand
extends CommandBase {
    public ChatChannelJoinCommand(KingdomCraftImpl kdc) {
        super(kdc, "chatchannel join", 1, true);
        this.addCommand("channel join");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdChatChannelJoinExplanation"));
        this.setPermissions("kingdom.chatchannel.join");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        return this.kdc.getChatManager().getChatChannels().stream().filter(ChatChannel::isToggleable).filter(c -> this.kdc.getChatManager().canTalk(sender, (ChatChannel)c)).map(ChatChannel::getName).collect(Collectors.toList());
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer player = (PlatformPlayer)sender;
        ChatChannel cc = this.kdc.getChatManager().getChatChannel(args[0]);
        if (cc == null || !this.kdc.getChatManager().canTalk(player, cc) || !cc.isEnabled()) {
            this.kdc.getMessages().send(sender, "cmdChatChannelNotExist", args[0]);
            return;
        }
        if (!cc.isToggleable()) {
            this.kdc.getMessages().send(sender, "cmdChatChannelNoToggle", cc.getName());
            return;
        }
        User user = this.kdc.getUser((PlatformPlayer)sender);
        UserChatChannel ucc = user.getChatChannel(cc.getName());
        if (ucc == null || ucc.isEnabled()) {
            this.kdc.getMessages().send(sender, "cmdChatChannelJoinAlready", cc.getName());
            return;
        }
        ucc.setEnabled(true);
        this.kdc.saveAsync(ucc);
        this.kdc.getMessages().send(sender, "cmdChatChannelJoin", cc.getName());
    }
}

