/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.chat;

import com.gufli.kingdomcraft.api.chat.ChatChannel;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class ChatChannelEnableCommand
extends CommandBase {
    public ChatChannelEnableCommand(KingdomCraftImpl kdc) {
        super(kdc, "chatchannel enable", 1);
        this.addCommand("channel enable");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdChatChannelEnableExplanation"));
        this.setPermissions("kingdom.chatchannel.enable");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        return this.kdc.getChatManager().getChatChannels().stream().map(ChatChannel::getName).collect(Collectors.toList());
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        ChatChannel cc = this.kdc.getChatManager().getChatChannel(args[0]);
        if (cc == null) {
            this.kdc.getMessages().send(sender, "cmdChatChannelNotExist", args[0]);
            return;
        }
        if (cc.isEnabled()) {
            this.kdc.getMessages().send(sender, "cmdChatChannelEnableAlready", cc.getName());
            return;
        }
        cc.setEnabled(true);
        List players = this.kdc.getOnlinePlayers().stream().filter(p -> this.kdc.getChatManager().canRead((PlatformPlayer)p, cc)).collect(Collectors.toList());
        if (!players.contains(sender)) {
            players.add(sender);
        }
        for (PlatformSender p2 : players) {
            this.kdc.getMessages().send(p2, "cmdChatChannelEnable", cc.getName());
        }
    }
}

