/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.chat;

import com.gufli.kingdomcraft.api.chat.ChatChannel;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class ChatChannelDisableCommand
extends CommandBase {
    public ChatChannelDisableCommand(KingdomCraftImpl kdc) {
        super(kdc, "chatchannel disable", 1);
        this.addCommand("channel disable");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdChatChannelDisableExplanation"));
        this.setPermissions("kingdom.chatchannel.disable");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        return this.kdc.getChatManager().getChatChannels().stream().map(ChatChannel::getName).collect(Collectors.toList());
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        ChatChannel cc = this.kdc.getChatManager().getChatChannel(args[0]);
        if (cc == null) {
            this.kdc.getMessages().send(sender, "cmdChatChannelNotExist", args[0]);
            return;
        }
        if (!cc.isEnabled()) {
            this.kdc.getMessages().send(sender, "cmdChatChannelDisableAlready", cc.getName());
            return;
        }
        cc.setEnabled(false);
        List players = this.kdc.getOnlinePlayers().stream().filter(p -> this.kdc.getChatManager().canRead((PlatformPlayer)p, cc)).collect(Collectors.toList());
        if (!players.contains(sender)) {
            players.add(sender);
        }
        for (PlatformSender p2 : players) {
            this.kdc.getMessages().send(p2, "cmdChatChannelDisable", cc.getName());
        }
    }
}

