/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.admin;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class SetKingdomCommand
extends CommandBase {
    public SetKingdomCommand(KingdomCraftImpl kdc) {
        super(kdc, "setkingdom", 2);
        this.setArgumentsHint("<player> <kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdSetKingdomExplanation"));
        this.setPermissions("kingdom.setkingdom");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getOnlinePlayers().stream().map(PlatformPlayer::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        this.kdc.getPlugin().getScheduler().executeAsync(() -> {
            try {
                User target = this.kdc.getUser(args[0]).get();
                if (target == null) {
                    this.kdc.getMessages().send(sender, "cmdErrorPlayerNotExist", args[0]);
                    return;
                }
                Kingdom kingdom = this.kdc.getKingdom(args[1]);
                if (kingdom == null || kingdom.isTemplate()) {
                    this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[1]);
                    return;
                }
                if (target.getKingdom() == kingdom) {
                    this.kdc.getMessages().send(sender, "cmdSetKingdomAlready", target.getName(), kingdom.getName());
                    return;
                }
                target.setKingdom(kingdom);
                this.kdc.saveAsync(target);
                PlatformPlayer tplayer = this.kdc.getPlayer(target);
                if (tplayer != null) {
                    this.kdc.getMessages().send((PlatformSender)tplayer, "cmdSetKingdomTarget", kingdom.getName());
                }
                this.kdc.getMessages().send(sender, "cmdSetKingdomSender", target.getName(), kingdom.getName());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }
}

