/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.admin;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class AdminOtherCommand
extends CommandBase {
    public AdminOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "admin", 1);
        this.setArgumentsHint("<player>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdAdminExplanation"));
        this.setPermissions("kingdom.admin.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getOnlinePlayers().stream().map(PlatformPlayer::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer target = this.kdc.getPlayer(args[0]);
        if (target == null) {
            this.kdc.getMessages().send(sender, "cmdErrorNotOnline", args[0]);
            return;
        }
        if (target.isAdmin()) {
            target.setAdmin(false);
            this.kdc.getMessages().send((PlatformSender)target, "cmdAdminDisableTarget", new String[0]);
            this.kdc.getMessages().send(sender, "cmdAdminDisableSender", target.getName());
        } else {
            target.setAdmin(true);
            this.kdc.getMessages().send((PlatformSender)target, "cmdAdminEnableTarget", new String[0]);
            this.kdc.getMessages().send(sender, "cmdAdminEnableSender", target.getName());
        }
    }
}

