/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.command;

import com.gufli.kingdomcraft.api.commands.Command;
import com.gufli.kingdomcraft.api.commands.CommandManager;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.commands.admin.AdminCommand;
import com.gufli.kingdomcraft.common.commands.admin.AdminOtherCommand;
import com.gufli.kingdomcraft.common.commands.admin.EditorCommand;
import com.gufli.kingdomcraft.common.commands.admin.EditorSaveCommand;
import com.gufli.kingdomcraft.common.commands.admin.PlayerDataClearCommand;
import com.gufli.kingdomcraft.common.commands.admin.SetKingdomCommand;
import com.gufli.kingdomcraft.common.commands.admin.SocialSpyCommand;
import com.gufli.kingdomcraft.common.commands.chat.ChatChannelDisableCommand;
import com.gufli.kingdomcraft.common.commands.chat.ChatChannelEnableCommand;
import com.gufli.kingdomcraft.common.commands.chat.ChatChannelJoinCommand;
import com.gufli.kingdomcraft.common.commands.chat.ChatChannelLeaveCommand;
import com.gufli.kingdomcraft.common.commands.chat.ChatCommand;
import com.gufli.kingdomcraft.common.commands.chat.DefaultChatChannelCommand;
import com.gufli.kingdomcraft.common.commands.edit.groups.GroupsAddCommand;
import com.gufli.kingdomcraft.common.commands.edit.groups.GroupsAddOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.groups.GroupsCommand;
import com.gufli.kingdomcraft.common.commands.edit.groups.GroupsListCommand;
import com.gufli.kingdomcraft.common.commands.edit.groups.GroupsListOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.groups.GroupsRemoveCommand;
import com.gufli.kingdomcraft.common.commands.edit.groups.GroupsRemoveOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.CreateCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.DeleteCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.DeleteOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditDefaultRankCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditDefaultRankOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditDisplayCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditDisplayOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditInviteOnlyCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditInviteOnlyOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditMaxMembersCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditMaxMembersOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditPrefixCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditPrefixOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditSuffixCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.EditSuffixOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.RenameCommand;
import com.gufli.kingdomcraft.common.commands.edit.kingdom.RenameOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksCloneCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksCreateCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksCreateOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksDeleteCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksDeleteOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditDisplayCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditDisplayOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditLevelCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditLevelOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditMaxMembersCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditMaxMembersOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditPrefixCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditPrefixOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditSuffixCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksEditSuffixOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksListCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksListOtherCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksRenameCommand;
import com.gufli.kingdomcraft.common.commands.edit.ranks.RanksRenameOtherCommand;
import com.gufli.kingdomcraft.common.commands.general.HelpCommand;
import com.gufli.kingdomcraft.common.commands.general.JoinCommand;
import com.gufli.kingdomcraft.common.commands.general.ListCommand;
import com.gufli.kingdomcraft.common.commands.member.BroadcastCommand;
import com.gufli.kingdomcraft.common.commands.member.BroadcastOtherCommand;
import com.gufli.kingdomcraft.common.commands.member.DemoteCommand;
import com.gufli.kingdomcraft.common.commands.member.InviteCommand;
import com.gufli.kingdomcraft.common.commands.member.KickCommand;
import com.gufli.kingdomcraft.common.commands.member.LeaveCommand;
import com.gufli.kingdomcraft.common.commands.member.PromoteCommand;
import com.gufli.kingdomcraft.common.commands.member.SetRankCommand;
import com.gufli.kingdomcraft.common.commands.relations.AllyCommand;
import com.gufli.kingdomcraft.common.commands.relations.AllyOtherCommand;
import com.gufli.kingdomcraft.common.commands.relations.EnemyCommand;
import com.gufli.kingdomcraft.common.commands.relations.EnemyOtherCommand;
import com.gufli.kingdomcraft.common.commands.relations.NeutralCommand;
import com.gufli.kingdomcraft.common.commands.relations.NeutralOtherCommand;
import com.gufli.kingdomcraft.common.commands.relations.TruceCommand;
import com.gufli.kingdomcraft.common.commands.relations.TruceOtherCommand;
import com.gufli.kingdomcraft.common.commands.spawn.SetSpawnCommand;
import com.gufli.kingdomcraft.common.commands.spawn.SetSpawnOtherCommand;
import com.gufli.kingdomcraft.common.commands.spawn.SpawnCommand;
import com.gufli.kingdomcraft.common.commands.spawn.SpawnOtherCommand;
import com.gufli.kingdomcraft.common.commands.spawn.TpAllSpawnCommand;
import com.gufli.kingdomcraft.common.commands.spawn.TpAllSpawnOtherCommand;
import com.gufli.kingdomcraft.common.commands.spawn.TpSpawnCommand;
import com.gufli.kingdomcraft.common.commands.spawn.TpSpawnOtherCommand;
import com.gufli.kingdomcraft.common.commands.tphere.TpHereCommand;
import com.gufli.kingdomcraft.common.commands.tphere.TpHereOtherCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class CommandManagerImpl
implements CommandManager {
    private final KingdomCraftImpl kdc;
    private final List<Command> commands = new ArrayList<Command>();

    public CommandManagerImpl(KingdomCraftImpl kdc) {
        this.kdc = kdc;
        this.registerDefaults();
    }

    @Override
    public void addCommand(Command command) {
        if (this.commands.contains(command)) {
            return;
        }
        if (command.getCommands().isEmpty()) {
            return;
        }
        this.commands.add(command);
    }

    @Override
    public void removeCommand(Command command) {
        this.commands.remove(command);
    }

    @Override
    public List<Command> getCommands() {
        return new ArrayList<Command>(this.commands);
    }

    private void registerDefaults() {
        this.commands.clear();
        this.addCommand(new HelpCommand(this.kdc));
        this.addCommand(new ListCommand(this.kdc));
        this.addCommand(new JoinCommand(this.kdc));
        this.addCommand(new ChatChannelJoinCommand(this.kdc));
        this.addCommand(new ChatChannelLeaveCommand(this.kdc));
        this.addCommand(new ChatChannelEnableCommand(this.kdc));
        this.addCommand(new ChatChannelDisableCommand(this.kdc));
        this.addCommand(new DefaultChatChannelCommand(this.kdc));
        this.addCommand(new LeaveCommand(this.kdc));
        this.addCommand(new SpawnCommand(this.kdc));
        this.addCommand(new InviteCommand(this.kdc));
        this.addCommand(new SetSpawnCommand(this.kdc));
        this.addCommand(new AllyCommand(this.kdc));
        this.addCommand(new AllyOtherCommand(this.kdc));
        this.addCommand(new EnemyCommand(this.kdc));
        this.addCommand(new EnemyOtherCommand(this.kdc));
        this.addCommand(new NeutralCommand(this.kdc));
        this.addCommand(new NeutralOtherCommand(this.kdc));
        this.addCommand(new TruceCommand(this.kdc));
        this.addCommand(new TruceOtherCommand(this.kdc));
        this.addCommand(new BroadcastCommand(this.kdc));
        this.addCommand(new BroadcastOtherCommand(this.kdc));
        this.addCommand(new SetRankCommand(this.kdc));
        this.addCommand(new PromoteCommand(this.kdc));
        this.addCommand(new DemoteCommand(this.kdc));
        this.addCommand(new SetKingdomCommand(this.kdc));
        this.addCommand(new KickCommand(this.kdc));
        this.addCommand(new SpawnOtherCommand(this.kdc));
        this.addCommand(new SetSpawnOtherCommand(this.kdc));
        this.addCommand(new TpSpawnCommand(this.kdc));
        this.addCommand(new TpSpawnOtherCommand(this.kdc));
        this.addCommand(new TpHereCommand(this.kdc));
        this.addCommand(new TpHereOtherCommand(this.kdc));
        this.addCommand(new TpAllSpawnCommand(this.kdc));
        this.addCommand(new TpAllSpawnOtherCommand(this.kdc));
        this.addCommand(new ChatCommand(this.kdc));
        this.addCommand(new AdminCommand(this.kdc));
        this.addCommand(new AdminOtherCommand(this.kdc));
        this.addCommand(new SocialSpyCommand(this.kdc));
        this.addCommand(new EditorCommand(this.kdc));
        this.addCommand(new EditorSaveCommand(this.kdc));
        this.addCommand(new PlayerDataClearCommand(this.kdc));
        this.addCommand(new CreateCommand(this.kdc));
        this.addCommand(new DeleteCommand(this.kdc));
        this.addCommand(new DeleteOtherCommand(this.kdc));
        this.addCommand(new RenameCommand(this.kdc));
        this.addCommand(new RenameOtherCommand(this.kdc));
        this.addCommand(new EditDefaultRankCommand(this.kdc));
        this.addCommand(new EditDefaultRankOtherCommand(this.kdc));
        this.addCommand(new EditDisplayCommand(this.kdc));
        this.addCommand(new EditDisplayOtherCommand(this.kdc));
        this.addCommand(new EditPrefixCommand(this.kdc));
        this.addCommand(new EditPrefixOtherCommand(this.kdc));
        this.addCommand(new EditSuffixCommand(this.kdc));
        this.addCommand(new EditSuffixOtherCommand(this.kdc));
        this.addCommand(new EditInviteOnlyCommand(this.kdc));
        this.addCommand(new EditInviteOnlyOtherCommand(this.kdc));
        this.addCommand(new EditMaxMembersCommand(this.kdc));
        this.addCommand(new EditMaxMembersOtherCommand(this.kdc));
        this.addCommand(new RanksListCommand(this.kdc));
        this.addCommand(new RanksListOtherCommand(this.kdc));
        this.addCommand(new RanksCreateCommand(this.kdc));
        this.addCommand(new RanksCreateOtherCommand(this.kdc));
        this.addCommand(new RanksRenameCommand(this.kdc));
        this.addCommand(new RanksRenameOtherCommand(this.kdc));
        this.addCommand(new RanksDeleteCommand(this.kdc));
        this.addCommand(new RanksDeleteOtherCommand(this.kdc));
        this.addCommand(new RanksEditDisplayCommand(this.kdc));
        this.addCommand(new RanksEditDisplayOtherCommand(this.kdc));
        this.addCommand(new RanksEditPrefixCommand(this.kdc));
        this.addCommand(new RanksEditPrefixOtherCommand(this.kdc));
        this.addCommand(new RanksEditSuffixCommand(this.kdc));
        this.addCommand(new RanksEditSuffixOtherCommand(this.kdc));
        this.addCommand(new RanksEditMaxMembersCommand(this.kdc));
        this.addCommand(new RanksEditMaxMembersOtherCommand(this.kdc));
        this.addCommand(new RanksEditLevelCommand(this.kdc));
        this.addCommand(new RanksEditLevelOtherCommand(this.kdc));
        this.addCommand(new RanksCloneCommand(this.kdc));
        this.addCommand(new GroupsCommand(this.kdc));
        this.addCommand(new GroupsListCommand(this.kdc));
        this.addCommand(new GroupsListOtherCommand(this.kdc));
        this.addCommand(new GroupsAddCommand(this.kdc));
        this.addCommand(new GroupsAddOtherCommand(this.kdc));
        this.addCommand(new GroupsRemoveCommand(this.kdc));
        this.addCommand(new GroupsRemoveOtherCommand(this.kdc));
    }

    public void sendInvalidUsage(PlatformSender sender, Command cmd) {
        this.sendInvalidUsage(sender, cmd, cmd.getCommands().get(0));
    }

    public void sendInvalidUsage(PlatformSender sender, Command cmd, String path) {
        String root = "kingdomcraft";
        if (this.kdc.getConfig().getCommandAliases().size() > 0) {
            root = this.kdc.getConfig().getCommandAliases().get(0);
        }
        this.kdc.getMessages().send(sender, "cmdErrorInvalidUsage", "/" + root + " " + path + " " + (cmd.getArgumentsHint() != null ? cmd.getArgumentsHint() : ""));
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(PlatformSender sender, String[] args) {
        void var8_11;
        if (args.length == 0) {
            return;
        }
        String invalidBase = null;
        String invalidArguments = "";
        for (Command cb2 : this.commands) {
            for (String string : cb2.getCommands()) {
                if (!(String.join((CharSequence)" ", args).toLowerCase() + " ").startsWith(string.toLowerCase() + " ")) continue;
                int cmdLength = string.split(Pattern.quote(" ")).length;
                String[] cmdArgs = this.convertArgs(Arrays.copyOfRange(args, cmdLength, args.length), cb2.getExpectedArguments());
                if (cb2.getExpectedArguments() != -1 && cmdArgs.length != cb2.getExpectedArguments()) {
                    invalidBase = string;
                    invalidArguments = cb2.getArgumentsHint() == null ? "" : cb2.getArgumentsHint();
                    continue;
                }
                if (cb2.isPlayerOnly() && !(sender instanceof PlatformPlayer)) {
                    sender.sendMessage("This command cannot be executed in the console!");
                    return;
                }
                if (cb2.getPermissions() != null && cb2.getPermissions().length > 0) {
                    if (Arrays.stream(cb2.getPermissions()).noneMatch(sender::hasPermission)) {
                        this.kdc.getMessages().send(sender, "cmdErrorNoPermission", new String[0]);
                        return;
                    }
                }
                cb2.execute(sender, cmdArgs);
                return;
            }
        }
        String root = "kingdomcraft";
        if (this.kdc.getConfig().getCommandAliases().size() > 0) {
            root = this.kdc.getConfig().getCommandAliases().get(0);
        }
        if (invalidBase != null) {
            this.kdc.getMessages().send(sender, "cmdErrorInvalidUsage", "/" + root + " " + invalidBase + " " + invalidArguments);
            return;
        }
        LevenshteinDistance ld = new LevenshteinDistance(5);
        HashMap<Command, String[]> candidates = new HashMap<Command, String[]>();
        for (Command cb3 : this.commands) {
            if (cb3.getPermissions() != null && cb3.getPermissions().length > 0) {
                if (Arrays.stream(cb3.getPermissions()).noneMatch(sender::hasPermission)) continue;
            }
            candidates.put(cb3, cb3.getCommands().get(0).split(Pattern.quote(" ")));
        }
        boolean bl = false;
        while (var8_11 < args.length) {
            void index = var8_11;
            HashMap filter = new HashMap();
            candidates.forEach((arg_0, arg_1) -> CommandManagerImpl.lambda$dispatch$0((int)index, filter, arg_0, arg_1));
            if (filter.size() == 0) break;
            List equal = filter.keySet().stream().filter(arg_0 -> CommandManagerImpl.lambda$dispatch$1(filter, (int)index, args, arg_0)).collect(Collectors.toList());
            if (!equal.isEmpty()) {
                candidates.entrySet().removeIf(e -> !equal.contains(e.getKey()));
            } else {
                Command closest = filter.keySet().stream().min(Comparator.comparingInt(arg_0 -> CommandManagerImpl.lambda$dispatch$3(ld, filter, (int)index, args, arg_0))).orElse(null);
                if (closest == null) break;
                String arg = ((String[])filter.get(closest))[index];
                List keep = filter.keySet().stream().filter(arg_0 -> CommandManagerImpl.lambda$dispatch$4(filter, (int)index, arg, arg_0)).collect(Collectors.toList());
                candidates.entrySet().removeIf(e -> !keep.contains(e.getKey()));
            }
            ++var8_11;
        }
        if (candidates.isEmpty()) {
            this.kdc.getMessages().send(sender, "cmdErrorInvalid", new String[0]);
            return;
        }
        Command command = candidates.keySet().stream().min(Comparator.comparingInt(cb -> {
            int baseLength = ((String[])candidates.get(cb)).length;
            int argsLength = cb.getArgumentsHint() == null ? 0 : cb.getArgumentsHint().split(Pattern.quote(" ")).length;
            return Math.abs(baseLength + argsLength - args.length);
        })).orElse(null);
        this.kdc.getMessages().send(sender, "cmdErrorInvalidHint", "/k " + command.getCommands().get(0) + (command.getArgumentsHint() != null ? " " + command.getArgumentsHint() : ""));
    }

    public List<String> dispatchAutocomplete(PlatformPlayer sender, String[] args) {
        if (args.length <= 1) {
            String arg0 = args[0].toLowerCase();
            ArrayList result = new ArrayList();
            this.commands.stream().filter(cb -> {
                if (cb.getPermissions() == null) return true;
                if (cb.getPermissions().length == 0) return true;
                if (!Arrays.stream(cb.getPermissions()).anyMatch(sender::hasPermission)) return false;
                return true;
            }).forEach(cb -> result.addAll(cb.getCommands().stream().map(c -> c.split(Pattern.quote(" "))[0]).filter(s2 -> s2.toLowerCase().startsWith(arg0)).collect(Collectors.toList())));
            return result.stream().distinct().collect(Collectors.toList());
        }
        String input = String.join((CharSequence)" ", args).toLowerCase();
        ArrayList<String> result = new ArrayList<String>();
        block0: for (Command cb2 : this.commands) {
            if (cb2.getPermissions() != null && cb2.getPermissions().length > 0) {
                if (Arrays.stream(cb2.getPermissions()).noneMatch(sender::hasPermission)) continue;
            }
            for (String cmd : cb2.getCommands()) {
                if ((input + " ").startsWith(cmd.toLowerCase() + " ")) {
                    String[] cmdArgs = Arrays.copyOfRange(args, cmd.split(Pattern.quote(" ")).length, args.length);
                    List<String> options = cb2.autocomplete(sender, cmdArgs);
                    if (options == null) continue block0;
                    result.addAll(options);
                    continue block0;
                }
                if (!cmd.toLowerCase().startsWith(input)) continue;
                result.add(cmd.split(Pattern.quote(" "))[args.length - 1]);
                continue block0;
            }
        }
        return result.stream().distinct().filter(s2 -> s2.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }

    private String[] convertArgs(String[] args, int expectedArgs) {
        if (expectedArgs <= 0) {
            return args;
        }
        if (args.length < expectedArgs) {
            return args;
        }
        List<String> currentArgs = Arrays.asList(args);
        String lastArgument = String.join((CharSequence)" ", currentArgs.subList(expectedArgs - 1, currentArgs.size()));
        if (lastArgument.startsWith("\"") && lastArgument.endsWith("\"") || lastArgument.startsWith("'") && lastArgument.endsWith("'")) {
            lastArgument = lastArgument.substring(1, lastArgument.length() - 1);
            ArrayList<String> newArgs = new ArrayList<String>(currentArgs.subList(0, expectedArgs - 1));
            newArgs.add(lastArgument);
            return newArgs.toArray(new String[0]);
        }
        return args;
    }
}

