/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.chat;

import com.gufli.kingdomcraft.api.chat.ChatChannel;
import com.gufli.kingdomcraft.api.chat.ChatChannelFactory;
import com.gufli.kingdomcraft.api.chat.ChatManager;
import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.domain.UserChatChannel;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.api.events.KingdomCreateEvent;
import com.gufli.kingdomcraft.api.events.KingdomDeleteEvent;
import com.gufli.kingdomcraft.api.events.PlayerChatEvent;
import com.gufli.kingdomcraft.api.events.PlayerLoadedEvent;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.chat.channels.BasicChatChannel;
import com.gufli.kingdomcraft.common.chat.channels.KingdomChatChannel;
import com.gufli.kingdomcraft.common.config.Configuration;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class ChatManagerImpl
implements ChatManager {
    private final KingdomCraftImpl kdc;
    private final List<ChatChannelFactory> factories = new ArrayList<ChatChannelFactory>();
    private final List<ChatChannel> chatChannels = new ArrayList<ChatChannel>();
    private ChatChannel defaultChannel;
    private boolean enabled;

    public ChatManagerImpl(KingdomCraftImpl kdc) {
        this.kdc = kdc;
        kdc.getEventManager().addListener((Class)PlayerLoadedEvent.class, e -> {
            if (!e.getPlayer().isSocialSpyEnabled()) {
                return;
            }
            if (!e.getPlayer().hasPermission("kingdom.socialspy")) {
                e.getPlayer().setSocialSpyEnabled(false);
                kdc.saveAsync(e.getPlayer().getUser());
                return;
            }
            kdc.getMessages().send((PlatformSender)e.getPlayer(), "socialSpyJoin", new String[0]);
        });
        kdc.getEventManager().addListener((Class)KingdomDeleteEvent.class, e -> this.getKingdomChannels(e.getKingdom()).forEach(ch -> {
            KingdomChatChannel kch = (KingdomChatChannel)ch;
            kch.getKingdoms().remove(e.getKingdom());
            if (kch.getKingdoms().isEmpty()) {
                this.removeChatChannel(kch);
            }
        }));
        kdc.getEventManager().addListener((Class)KingdomCreateEvent.class, e -> {
            for (ChatChannelFactory f : this.factories) {
                if (!f.shouldCreate(e.getKingdom())) continue;
                this.addChatChannel(f.create(e.getKingdom()));
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public List<ChatChannel> getChatChannels() {
        return this.chatChannels;
    }

    @Override
    public ChatChannel getChatChannel(String name) {
        return this.chatChannels.stream().filter(c -> c.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public void addChatChannel(ChatChannel chatChannel) {
        if (chatChannel == null) {
            return;
        }
        if (!this.chatChannels.contains(chatChannel)) {
            this.chatChannels.add(chatChannel);
        }
    }

    @Override
    public void removeChatChannel(ChatChannel chatChannel) {
        this.chatChannels.remove(chatChannel);
    }

    @Override
    public void setDefaultChatChannel(ChatChannel chatChannel) {
        this.defaultChannel = chatChannel;
    }

    @Override
    public ChatChannel getDefaultChatChannel() {
        return this.defaultChannel;
    }

    private boolean canAccess(PlatformPlayer player, ChatChannel channel) {
        KingdomChatChannel ch;
        User user = this.kdc.getUser(player);
        if (user == null) {
            return false;
        }
        if (channel instanceof KingdomChatChannel && !(ch = (KingdomChatChannel)channel).getKingdoms().contains(user.getKingdom())) {
            return false;
        }
        return channel.getRestrictMode() != ChatChannel.RestrictMode.READ || player.hasPermission(channel.getPermission());
    }

    @Override
    public boolean canTalk(PlatformPlayer player, ChatChannel channel) {
        if (!this.canAccess(player, channel)) {
            return false;
        }
        return channel.getRestrictMode() != ChatChannel.RestrictMode.TALK || player.hasPermission(channel.getPermission());
    }

    @Override
    public boolean canRead(PlatformPlayer player, ChatChannel channel) {
        UserChatChannel ucc;
        if (!this.canAccess(player, channel)) {
            return false;
        }
        User user = this.kdc.getUser(player);
        return !channel.isToggleable() || (ucc = user.getChatChannel(channel.getName())) == null || ucc.isEnabled();
    }

    List<ChatChannel> getKingdomChannels(Kingdom kingdom) {
        return this.getChatChannels().stream().filter(ch -> ch instanceof KingdomChatChannel).filter(ch -> ((KingdomChatChannel)ch).getKingdoms().contains(kingdom)).collect(Collectors.toList());
    }

    @Override
    public void dispatch(PlatformPlayer player, String message) {
        List channels = this.getChatChannels().stream().filter(ChatChannel::isEnabled).filter(c -> this.canTalk(player, (ChatChannel)c)).sorted(Comparator.comparingInt(ch -> ch.getPrefix() == null ? 0 : -ch.getPrefix().length())).collect(Collectors.toList());
        String strippedMessage = this.kdc.getPlugin().decolorify(message);
        ChatChannel channel = null;
        if (player.has("DEFAULT_CHATCHANNEL")) {
            channel = channels.stream().filter(ch -> ch.getName().equals(player.get("DEFAULT_CHATCHANNEL", String.class))).findFirst().orElse(null);
        }
        if (player.hasPermission("kingdom.defaultchatchannel")) {
            if (channel != null && channel.getPrefix() != null && channel.getPrefix().equals(strippedMessage)) {
                player.remove("DEFAULT_CHATCHANNEL");
                this.kdc.getMessages().send((PlatformSender)player, "cmdDefaultChatChannelDisable", new String[0]);
                return;
            }
            for (ChatChannel ch2 : channels) {
                if (ch2.getPrefix() == null || ch2.getPrefix().equals("") || !ch2.getPrefix().equals(strippedMessage)) continue;
                player.set("DEFAULT_CHATCHANNEL", ch2.getName());
                this.kdc.getMessages().send((PlatformSender)player, "cmdDefaultChatChannel", ch2.getName());
                return;
            }
        }
        for (ChatChannel ch2 : channels) {
            if (ch2 == channel || ch2.getPrefix() != null && !strippedMessage.startsWith(ch2.getPrefix())) continue;
            if (channel != null && channel.getPrefix() != null && ch2.getPrefix() != null && ch2.getPrefix().equals("")) {
                if (!strippedMessage.startsWith(channel.getPrefix())) continue;
                message = message.replaceFirst(Pattern.quote(channel.getPrefix()), "");
                channel = ch2;
                break;
            }
            if (ch2.getPrefix() != null) {
                message = message.replaceFirst(Pattern.quote(ch2.getPrefix()), "");
            }
            channel = ch2;
            break;
        }
        if (channel == null) {
            if (this.getDefaultChatChannel() == null) {
                this.kdc.getMessages().send((PlatformSender)player, "chatNoChannel", new String[0]);
                return;
            }
            channel = this.getDefaultChatChannel();
        }
        String cooldownKey = "CHAT_COOLDOWN_" + channel.getName();
        if (channel.getCooldown() > 0 && player.has(cooldownKey) && !player.hasPermission("kingdom.chat.bypass.cooldown")) {
            long lastMessage = player.get(cooldownKey, Long.class);
            long diff = System.currentTimeMillis() - lastMessage;
            if (diff < (long)channel.getCooldown() * 1000L) {
                float remaining = (float)((long)(channel.getCooldown() * 1000) - diff) / 1000.0f;
                DecimalFormat df = new DecimalFormat("0.0");
                this.kdc.getMessages().send((PlatformSender)player, "chatChannelCooldown", df.format(remaining));
                return;
            }
        }
        if (this.kdc.getPlugin().decolorify(message).equals("")) {
            return;
        }
        this.dispatch(player, channel, message);
    }

    @Override
    public void dispatch(PlatformPlayer player, ChatChannel channel, String message) {
        List<PlatformPlayer> receivers = this.kdc.getOnlinePlayers().stream().filter(p -> this.canRead((PlatformPlayer)p, channel)).filter(p -> channel.getRange() <= 0 || p.getLocation().distanceTo(player.getLocation()) <= (double)channel.getRange()).collect(Collectors.toList());
        PlayerChatEvent event = new PlayerChatEvent(player, channel, message, channel.getFormat(), receivers);
        this.kdc.getEventManager().dispatch(event);
        if (event.isCancelled()) {
            return;
        }
        message = event.getMessage();
        if (message == null) {
            return;
        }
        String result = event.getFormat();
        result = StringEscapeUtils.unescapeJava(result);
        result = this.kdc.getPlaceholderManager().handle(player, result);
        result = this.kdc.getMessages().colorify(result);
        if (player.hasPermission("kingdom.chat.colors")) {
            message = this.kdc.getMessages().colorify(message);
        }
        result = this.kdc.getPlaceholderManager().strip(result, "message", "player");
        result = result.replace("{message}", message);
        result = result.replace("{player}", player.getName());
        List<PlatformPlayer> finalReceivers = event.getReceivers();
        if (finalReceivers == null || finalReceivers.isEmpty()) {
            return;
        }
        if (channel.getCooldown() > 0 && !player.hasPermission("kingdom.chat.bypass.cooldown")) {
            player.set("CHAT_COOLDOWN_" + channel.getName(), System.currentTimeMillis());
        }
        if (!receivers.contains(player)) {
            receivers.add(player);
        }
        String finalResult = result;
        for (PlatformPlayer p2 : receivers) {
            p2.sendMessage(finalResult);
        }
        String ss = this.kdc.getMessages().getMessage("socialSpyPrefix", channel.getName()) + finalResult;
        this.kdc.getOnlinePlayers().stream().filter(PlatformPlayer::isSocialSpyEnabled).filter(p -> !receivers.contains(p)).forEach(p -> p.sendMessage(ss));
        this.kdc.getPlugin().log("[" + channel.getName() + "] " + player.getName() + ": " + message);
    }

    public void load(Configuration config) {
        ChatChannel ch;
        boolean bl = this.enabled = config.contains("enabled") && config.getBoolean("enabled");
        if (!this.enabled) {
            return;
        }
        if (!config.contains("channels") || config.getConfigurationSection("channels") == null) {
            return;
        }
        this.factories.clear();
        this.chatChannels.clear();
        String defaultchannel = config.getString("default-channel");
        Configuration channels = config.getConfigurationSection("channels");
        for (String name : channels.getKeys(false)) {
            Configuration cs = channels.getConfigurationSection(name);
            if (!cs.contains("format")) {
                this.kdc.getPlugin().log("Cannot create channel with name '" + name + "' because no format is given.", Level.WARNING);
                continue;
            }
            if (cs.contains("kingdoms")) {
                ChatChannelFactory factory = this.createFactory(name, cs);
                this.addFactory(factory);
                continue;
            }
            BasicChatChannel ch2 = new BasicChatChannel(name);
            this.setup(ch2, cs);
            this.addChatChannel(ch2);
        }
        if (defaultchannel != null && (ch = this.getChatChannel(defaultchannel)) != null) {
            this.setDefaultChatChannel(ch);
        }
    }

    private void addFactory(ChatChannelFactory factory) {
        this.factories.add(factory);
        for (Kingdom kd : this.kdc.getKingdoms()) {
            if (!factory.shouldCreate(kd)) continue;
            this.addChatChannel(factory.create(kd));
        }
    }

    private void setup(ChatChannel channel, Configuration section) {
        channel.setFormat(section.getString("format"));
        if (section.contains("prefix")) {
            channel.setPrefix(section.getString("prefix"));
        }
        if (section.contains("toggleable")) {
            channel.setToggleable(section.getBoolean("toggleable"));
        }
        if (section.contains("restrict")) {
            if (section.get("restrict") instanceof Boolean) {
                boolean val = section.getBoolean("restrict");
                if (val) {
                    channel.setRestrictMode(ChatChannel.RestrictMode.READ);
                } else {
                    channel.setRestrictMode(ChatChannel.RestrictMode.NONE);
                }
            } else {
                ChatChannel.RestrictMode mode = ChatChannel.RestrictMode.get(section.getString("restrict"));
                if (mode == null) {
                    channel.setRestrictMode(ChatChannel.RestrictMode.NONE);
                } else {
                    channel.setRestrictMode(mode);
                }
            }
        }
        if (section.contains("range")) {
            channel.setRange(section.getInt("range"));
        }
        if (section.contains("cooldown")) {
            channel.setCooldown(section.getInt("cooldown"));
        }
    }

    private ChatChannelFactory createFactory(final String name, final Configuration section) {
        boolean allKingdoms = false;
        final ArrayList<String> kingdoms = new ArrayList<String>();
        if (section.get("kingdoms") instanceof String) {
            if (section.getString("kingdoms").equals("*")) {
                allKingdoms = true;
            } else {
                kingdoms.add(section.getString("kingdoms"));
            }
        } else {
            kingdoms.addAll(section.getStringList("kingdoms"));
        }
        final boolean finalAllKingdoms = allKingdoms;
        return new ChatChannelFactory(){

            @Override
            public boolean shouldCreate(Kingdom kingdom) {
                return finalAllKingdoms || kingdoms.contains(kingdom.getName().toLowerCase());
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public ChatChannel create(Kingdom kingdom) {
                if (!finalAllKingdoms && kingdoms.size() > 1) {
                    KingdomChatChannel ch = (KingdomChatChannel)ChatManagerImpl.this.getChatChannel(this.getName());
                    if (ch == null) {
                        ch = new KingdomChatChannel(this.getName(), kingdom);
                        ChatManagerImpl.this.setup(ch, section);
                    } else {
                        ch.getKingdoms().add(kingdom);
                    }
                    return ch;
                }
                KingdomChatChannel ch = new KingdomChatChannel(this.getName() + "-" + kingdom.getName(), kingdom);
                ChatManagerImpl.this.setup(ch, section);
                return ch;
            }
        };
    }
}

