/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common;

import com.gufli.kingdomcraft.api.KingdomCraft;
import com.gufli.kingdomcraft.api.KingdomCraftProvider;
import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Model;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.events.KingdomCreateEvent;
import com.gufli.kingdomcraft.api.events.PlayerLeaveEvent;
import com.gufli.kingdomcraft.api.placeholders.PlaceholderManager;
import com.gufli.kingdomcraft.common.KingdomCraftPlugin;
import com.gufli.kingdomcraft.common.chat.ChatManagerImpl;
import com.gufli.kingdomcraft.common.command.CommandManagerImpl;
import com.gufli.kingdomcraft.common.config.Config;
import com.gufli.kingdomcraft.common.ebean.StorageContext;
import com.gufli.kingdomcraft.common.editor.EditorImpl;
import com.gufli.kingdomcraft.common.event.EventManagerImpl;
import com.gufli.kingdomcraft.common.messages.MessagesImpl;
import com.gufli.kingdomcraft.common.permissions.PermissionManager;
import com.gufli.kingdomcraft.common.placeholders.PlaceholderManagerImpl;
import com.gufli.kingdomcraft.common.util.Teleporter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class KingdomCraftImpl
implements KingdomCraft {
    private final KingdomCraftPlugin plugin;
    private final Config config = new Config();
    private final StorageContext context;
    private final MessagesImpl messages;
    private final CommandManagerImpl commandManager;
    private final PermissionManager permissionManager;
    private final EventManagerImpl eventManager;
    private final ChatManagerImpl chatManager;
    private final PlaceholderManagerImpl placeholderManager;
    private final EditorImpl editor;

    public KingdomCraftImpl(KingdomCraftPlugin plugin, StorageContext context) {
        this.plugin = plugin;
        this.context = context;
        this.messages = new MessagesImpl(plugin);
        this.commandManager = new CommandManagerImpl(this);
        this.eventManager = new EventManagerImpl();
        this.chatManager = new ChatManagerImpl(this);
        this.placeholderManager = new PlaceholderManagerImpl(this);
        this.permissionManager = new PermissionManager(this);
        this.editor = new EditorImpl(this);
        context.registerDumpCommand(this);
        KingdomCraftProvider.register(this);
        Teleporter.register(this.getPlugin().getScheduler());
    }

    public void stop() {
        this.context.stop();
    }

    public KingdomCraftPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public MessagesImpl getMessages() {
        return this.messages;
    }

    @Override
    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    @Override
    public ChatManagerImpl getChatManager() {
        return this.chatManager;
    }

    @Override
    public EventManagerImpl getEventManager() {
        return this.eventManager;
    }

    @Override
    public CommandManagerImpl getCommandManager() {
        return this.commandManager;
    }

    @Override
    public EditorImpl getEditor() {
        return this.editor;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public Set<PlatformPlayer> getOnlinePlayers() {
        return this.context.getPlayers();
    }

    @Override
    public PlatformPlayer getPlayer(UUID uuid) {
        return this.context.getPlayer(uuid);
    }

    @Override
    public PlatformPlayer getPlayer(User user) {
        return this.context.getPlayer(user);
    }

    @Override
    public PlatformPlayer getPlayer(String name) {
        return this.context.getPlayer(name);
    }

    @Override
    public Set<Kingdom> getKingdoms() {
        return this.context.getKingdoms();
    }

    @Override
    public Set<Kingdom> getKingdoms(boolean includeTemplate) {
        Set<Kingdom> kingdoms = this.context.getKingdoms();
        if (includeTemplate) {
            kingdoms.add(this.getTemplateKingdom());
        }
        return kingdoms;
    }

    @Override
    public Kingdom getKingdom(String name) {
        if (name.equalsIgnoreCase("template")) {
            return this.getTemplateKingdom();
        }
        return this.context.getKingdom(name);
    }

    @Override
    public Kingdom getKingdom(long id) {
        return this.context.getKingdom(id);
    }

    @Override
    public CompletableFuture<Kingdom> createKingdom(String name) {
        if (this.getKingdom(name) != null) {
            throw new IllegalArgumentException("A kingdom with that name already exists.");
        }
        Kingdom kingdom = this.context.createKingdom(name);
        return this.saveAsync(kingdom).thenApply(unused -> {
            this.eventManager.dispatch(new KingdomCreateEvent(kingdom));
            return kingdom;
        });
    }

    @Override
    public Kingdom getTemplateKingdom() {
        return this.context.getTemplateKingdom();
    }

    @Override
    public Set<Relation> getRelations(Kingdom kingdom) {
        return this.context.getRelations(kingdom);
    }

    @Override
    public void setRelation(Kingdom kingdom, Kingdom other, RelationType type) {
        this.context.setRelation(kingdom, other, type);
    }

    @Override
    public Relation getRelation(Kingdom kingdom, Kingdom other) {
        return this.context.getRelation(kingdom, other);
    }

    @Override
    public void addRelationRequest(Kingdom kingdom, Kingdom other, RelationType type) {
        this.context.addRelationRequest(kingdom, other, type);
    }

    @Override
    public Relation getRelationRequest(Kingdom kingdom, Kingdom other) {
        return this.context.getRelationRequest(kingdom, other);
    }

    @Override
    public void removeRelationRequest(Kingdom kingdom, Kingdom other) {
        this.context.removeRelationRequest(kingdom, other);
    }

    public void clearUsers() {
        this.context.clearUsers();
    }

    public void purgeUsers() {
        this.context.purgeUsers();
    }

    @Override
    public Set<User> getOnlineUsers() {
        return this.context.getOnlineUsers();
    }

    @Override
    public User getOnlineUser(String name) {
        return this.context.getOnlineUser(name);
    }

    @Override
    public User getOnlineUser(UUID uuid) {
        return this.context.getOnlineUser(uuid);
    }

    @Override
    public CompletableFuture<List<User>> getUsers() {
        return this.context.getUsers();
    }

    @Override
    public CompletableFuture<User> getUser(String name) {
        return this.context.getUser(name);
    }

    @Override
    public CompletableFuture<User> getUser(UUID uuid) {
        return this.context.getUser(uuid);
    }

    @Override
    public User getUser(PlatformPlayer player) {
        return this.getOnlineUser(player.getUniqueId());
    }

    @Override
    public CompletableFuture<Void> saveAsync(Model ... models) {
        return this.context.saveAsync(models);
    }

    @Override
    public <T extends Model> CompletableFuture<Void> saveAsync(Collection<T> models) {
        return this.context.saveAsync(models);
    }

    @Override
    public CompletableFuture<Void> deleteAsync(Model ... models) {
        return this.context.deleteAsync(models);
    }

    @Override
    public <T extends Model> CompletableFuture<Void> deleteAsync(Collection<T> models) {
        return this.context.deleteAsync(models);
    }

    @Override
    public String colorify(String str) {
        return this.plugin.colorify(str);
    }

    public Consumer<PlatformPlayer> onLogin(UUID id, String name) {
        return this.onLoad(id, name);
    }

    private Consumer<PlatformPlayer> onLoad(UUID id, String name) {
        try {
            User user = this.getUser(id).get();
            if (user == null) {
                user = this.getUser(name).get();
            }
            if (user == null) {
                user = this.context.createUser(id, name);
                this.saveAsync(user);
            } else if (!user.getName().equals(name)) {
                this.context.updateName(user, name);
            } else if (!user.getUniqueId().equals(id)) {
                this.context.updateUUID(user, id);
            } else {
                this.context.login(user);
            }
            User finalUser = user;
            return player -> this.context.addPlayer((PlatformPlayer)player, finalUser);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void onQuit(PlatformPlayer player) {
        this.eventManager.dispatch(new PlayerLeaveEvent(player));
        this.context.removePlayer(player);
    }
}

