/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.reflection;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class VersionUtils {
    public static String getVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1).replace("_", ".");
    }

    public static int compareVersions(String v1, String v2) {
        int[] va1 = VersionUtils.parseVersion(v1);
        int[] va2 = VersionUtils.parseVersion(v2);
        for (int i = 0; i < Math.min(va2.length, va1.length); ++i) {
            if (va1[i] == va2[i]) continue;
            return Integer.compare(va1[i], va2[i]);
        }
        return 0;
    }

    private static int[] parseVersion(String version) {
        String[] va = version.split(Pattern.quote("."));
        String vl = va[va.length - 1];
        for (int i = 0; i < vl.length(); ++i) {
            if (Character.isDigit(vl.charAt(i))) continue;
            va[va.length - 1] = vl.substring(0, i);
            break;
        }
        return Arrays.stream(va).filter(s2 -> !s2.equals("")).mapToInt(Integer::parseInt).toArray();
    }

    public static boolean isMcLowerOrEqualTo(String version) {
        return VersionUtils.compareVersions(VersionUtils.getVersion(), version) <= 0;
    }

    public static boolean isMcLowerThan(String version) {
        return VersionUtils.compareVersions(VersionUtils.getVersion(), version) < 0;
    }

    public static boolean isMcGreaterThan(String version) {
        return VersionUtils.compareVersions(VersionUtils.getVersion(), version) > 0;
    }

    public static boolean isMcGreaterOrEqualTo(String version) {
        return VersionUtils.compareVersions(VersionUtils.getVersion(), version) >= 0;
    }
}

