/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.permissions;

import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.events.PlayerLeaveEvent;
import com.gufli.kingdomcraft.api.events.PlayerLoadedEvent;
import com.gufli.kingdomcraft.api.events.PluginReloadEvent;
import com.gufli.kingdomcraft.api.events.UserJoinKingdomEvent;
import com.gufli.kingdomcraft.api.events.UserLeaveKingdomEvent;
import com.gufli.kingdomcraft.api.events.UserRankChangeEvent;
import com.gufli.kingdomcraft.bukkit.KingdomCraftBukkitPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class VaultPermissionListener
implements Listener {
    private final KingdomCraftBukkitPlugin plugin;
    private final Permission permissionProvider;
    private final List<String> allExternals = new ArrayList<String>();

    public VaultPermissionListener(KingdomCraftBukkitPlugin plugin, Permission permissionProvider) {
        this.plugin = plugin;
        this.permissionProvider = permissionProvider;
        this.loadExternals();
        plugin.getKdc().getEventManager().addListener((Class)PluginReloadEvent.class, this::onReload);
        plugin.getKdc().getEventManager().addListener((Class)PlayerLoadedEvent.class, this::onJoin);
        plugin.getKdc().getEventManager().addListener((Class)PlayerLeaveEvent.class, this::onLeave);
        plugin.getKdc().getEventManager().addListener((Class)UserJoinKingdomEvent.class, this::onKingdomJoin);
        plugin.getKdc().getEventManager().addListener((Class)UserLeaveKingdomEvent.class, this::onKingdomLeave);
        plugin.getKdc().getEventManager().addListener((Class)UserRankChangeEvent.class, this::onRankChange);
    }

    public void onReload(PluginReloadEvent e) {
        this.loadExternals();
    }

    public void onJoin(PlayerLoadedEvent e) {
        this.update(e.getPlayer());
    }

    public void onLeave(PlayerLeaveEvent e) {
        this.update(e.getPlayer());
    }

    public void onKingdomJoin(UserJoinKingdomEvent e) {
        this.update(e.getUser());
    }

    public void onKingdomLeave(UserLeaveKingdomEvent e) {
        this.update(e.getUser());
    }

    public void onRankChange(UserRankChangeEvent e) {
        this.update(e.getUser());
    }

    private void loadExternals() {
        this.allExternals.clear();
        this.plugin.getKdc().getPermissionManager().getGroups().forEach(group -> this.allExternals.addAll(group.getExternals()));
    }

    private void update(User user) {
        PlatformPlayer player = this.plugin.getKdc().getPlayer(user);
        if (player != null) {
            this.update(player);
        }
    }

    private void update(PlatformPlayer player) {
        Player bplayer = Bukkit.getPlayer((UUID)player.getUniqueId());
        ArrayList externals = new ArrayList();
        Rank rank = player.getUser().getRank();
        if (rank != null) {
            this.plugin.getKdc().getPermissionManager().getGroups(rank).forEach(group -> externals.addAll(group.getExternals()));
        }
        ArrayList<String> distinctExternals = new ArrayList<String>(this.allExternals);
        distinctExternals.removeIf(externals::contains);
        for (String group2 : distinctExternals) {
            if (!this.permissionProvider.playerInGroup(bplayer, group2)) continue;
            this.permissionProvider.playerRemoveGroup(bplayer, group2);
        }
        for (String group2 : externals) {
            if (this.permissionProvider.playerInGroup(bplayer, group2)) continue;
            this.permissionProvider.playerAddGroup(bplayer, group2);
        }
    }
}

