/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.menu;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.api.gui.InventoryClickType;
import com.gufli.kingdomcraft.bukkit.entity.BukkitPlayer;
import com.gufli.kingdomcraft.bukkit.gui.BukkitInventory;
import com.gufli.kingdomcraft.bukkit.gui.BukkitInventoryItem;
import com.gufli.kingdomcraft.bukkit.gui.InventoryBuilder;
import com.gufli.kingdomcraft.bukkit.gui.ItemStackBuilder;
import com.gufli.kingdomcraft.bukkit.gui.PaginationBuilder;
import com.gufli.kingdomcraft.bukkit.item.BukkitItem;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class KingdomMenu {
    static KingdomCraftImpl kdc;
    private static final Map<RelationType, Integer> RELATION_ORDER;

    private static String text(String key) {
        String msg = kdc.getMessages().getMessage(key, true, new String[0]);
        if (msg == null) {
            return "";
        }
        return msg;
    }

    private static String text(String key, String ... placeholders) {
        String msg = kdc.getMessages().getMessage(key, true, placeholders);
        if (msg == null) {
            return "";
        }
        return msg;
    }

    private static String colorify(String text) {
        return kdc.getMessages().colorify(text);
    }

    static void withBack(InventoryBuilder builder, Runnable back) {
        if (back != null) {
            builder.withHotbarItem(4, ItemStackBuilder.of(Material.BARRIER).withName(KingdomMenu.text("menuBack")).build(), (p, ct) -> {
                back.run();
                return true;
            });
        }
    }

    static void withBack(PaginationBuilder builder, Runnable back) {
        if (back != null) {
            builder.withHotbarItem(4, ItemStackBuilder.of(Material.BARRIER).withName(KingdomMenu.text("menuBack")).build(), (p, ct) -> {
                back.run();
                return true;
            });
        }
    }

    public static void open(PlatformPlayer player) {
        InventoryBuilder builder = InventoryBuilder.create().withTitle(KingdomMenu.text("menuTitle"));
        builder.withItem(ItemStackBuilder.of(Material.DIAMOND_SWORD).withName(KingdomMenu.text("menuItemKingdomsList", kdc.getKingdoms().size() + "")).build(), (p, ct) -> KingdomMenu.openKingdomsList(player, () -> KingdomMenu.open(player)));
        if (player.getUser().getKingdom() != null) {
            builder.withItem(KingdomMenu.getKingdomItem(player.getUser().getKingdom()), (p, ct) -> KingdomMenu.openKingdomInfo(player, player.getUser().getKingdom(), () -> KingdomMenu.open(player)));
        }
        builder.withItem(ItemStackBuilder.skull().withName(KingdomMenu.text("menuItemPlayersList", kdc.getOnlinePlayers().size() + "")).build(), (p, ct) -> KingdomMenu.openPlayerList(player, () -> KingdomMenu.open(player)));
        player.openInventory(builder.build());
    }

    static void openKingdomsList(PlatformPlayer player, Runnable back) {
        PaginationBuilder builder = PaginationBuilder.create().withTitle(KingdomMenu.text("menuPlayersListTitle"));
        ArrayList<Kingdom> kingdoms = new ArrayList<Kingdom>(kdc.getKingdoms());
        builder.withItems(kingdoms.size(), index -> {
            Kingdom kingdom = (Kingdom)kingdoms.get((int)index);
            return new BukkitInventoryItem(KingdomMenu.getKingdomItem(kingdom), (p, ct) -> {
                KingdomMenu.openKingdomInfo(player, kingdom, () -> KingdomMenu.openKingdomsList(player, back));
                return true;
            });
        });
        KingdomMenu.withBack(builder, back);
        player.openInventory(builder.build());
    }

    static void openPlayerList(PlatformPlayer player, Runnable back) {
        PaginationBuilder builder = PaginationBuilder.create().withTitle(KingdomMenu.text("menuPlayersListTitle"));
        List users = kdc.getOnlinePlayers().stream().filter(op -> ((BukkitPlayer)player).getPlayer().canSee(((BukkitPlayer)op).getPlayer())).map(PlatformPlayer::getUser).collect(Collectors.toList());
        builder.withItems(users.size(), index -> {
            User user = (User)users.get((int)index);
            return new BukkitInventoryItem(ItemStackBuilder.skull().withName(ChatColor.GREEN + user.getName()).withSkullOwner((OfflinePlayer)Bukkit.getPlayer((UUID)user.getUniqueId())).build(), (p, ct) -> {
                KingdomMenu.openPlayerInfo(player, user, () -> KingdomMenu.openPlayerList(player, back));
                return true;
            });
        });
        KingdomMenu.withBack(builder, back);
        builder.buildAsync(player, kdc.getPlugin().getScheduler().sync(), kdc.getPlugin().getScheduler().async());
    }

    public static void openPlayerInfo(PlatformPlayer player, User target) {
        KingdomMenu.openPlayerInfo(player, target, null);
    }

    static void openPlayerInfo(PlatformPlayer player, User target, Runnable back) {
        User user = player.getUser();
        kdc.getPlugin().getScheduler().async().execute(() -> {
            InventoryBuilder builder = InventoryBuilder.create().withTitle(ChatColor.DARK_GRAY + target.getName());
            ZoneId timeZone = kdc.getConfig().getTimeZone();
            builder.withItem(ItemStackBuilder.skull().withName(ChatColor.GOLD + target.getName()).apply(b -> {
                if (target.getKingdom() != null) {
                    b.withLore("");
                    b.withLore(KingdomMenu.text("menuInfoKingdom", KingdomMenu.colorify(target.getKingdom().getDisplay())));
                    if (target.getRank() != null) {
                        b.withLore(KingdomMenu.text("menuInfoRank", KingdomMenu.colorify(target.getRank().getDisplay())));
                    }
                    if (target.getJoinedKingdomAt() != null) {
                        ZonedDateTime zdt = target.getJoinedKingdomAt().atZone(timeZone);
                        b.withLore(KingdomMenu.text("menuInfoKingdomJoined", zdt.format(kdc.getConfig().getDateFormat())));
                    }
                }
            }).apply(b -> {
                b.withLore("");
                if (kdc.getPlayer(target) != null) {
                    b.withLore(KingdomMenu.text("menuInfoLastSeen", "now"));
                    return;
                }
                ZonedDateTime zdt = target.getLastOnlineAt() != null ? target.getLastOnlineAt().atZone(timeZone) : target.getUpdatedAt().atZone(timeZone);
                if (zdt.toLocalDate().equals(LocalDate.now(timeZone))) {
                    b.withLore(KingdomMenu.text("menuInfoLastSeen", zdt.format(kdc.getConfig().getTimeFormat())));
                } else {
                    b.withLore(KingdomMenu.text("menuInfoLastSeen", zdt.format(kdc.getConfig().getDateFormat())));
                }
            }).withLore(KingdomMenu.text("menuInfoFirstLogin", target.getCreatedAt().atZone(timeZone).format(kdc.getConfig().getDateFormat()))).apply(b -> {
                Player p = Bukkit.getPlayer((UUID)target.getUniqueId());
                if (p != null) {
                    b.withSkullOwner((OfflinePlayer)p);
                }
            }).build());
            if (target.getKingdom() != null) {
                builder.withItem(KingdomMenu.getKingdomItem(target.getKingdom()), (p, ct) -> {
                    KingdomMenu.openKingdomInfo(player, target.getKingdom(), () -> KingdomMenu.openPlayerInfo(player, target, back));
                    return true;
                });
                if (player.hasPermission("kingdom.kick.other") || player.hasPermission("kingdom.kick") && player.getUser().getKingdom() == target.getKingdom() && user.getRank() != null && (target.getRank() == null || user.getRank().getLevel() > target.getRank().getLevel())) {
                    builder.withItem(ItemStackBuilder.of(Material.IRON_AXE).withName(KingdomMenu.text("menuPlayerInfoItemKick")).withLore(KingdomMenu.text("menuPlayerInfoItemLoreKick")).build(), (p, ct) -> KingdomMenu.openConfirmMenu(player, KingdomMenu.text("menuPlayerKickConfirmTitle", target.getName()), () -> {
                        ((BukkitPlayer)player).getPlayer().chat("/k kick " + target.getName());
                        KingdomMenu.openPlayerInfo(player, target, back);
                    }, () -> KingdomMenu.openPlayerInfo(player, target, back)));
                }
                if (!(target.getKingdom().getRanks().isEmpty() || target.getKingdom().getRanks().size() == 1 && target.getRank() != null || !player.hasPermission("kingdom.setrank.other") && (!player.hasPermission("kingdom.setrank") || player.getUser().getKingdom() != target.getKingdom() || user.getRank() == null || target.getRank() != null && user.getRank().getLevel() <= target.getRank().getLevel()))) {
                    builder.withItem(ItemStackBuilder.of(Material.BLAZE_POWDER).withName(KingdomMenu.text("menuPlayerInfoItemChangeRank")).withLore(KingdomMenu.text("menuPlayerInfoItemLoreChangeRank")).build(), (p, ct) -> {
                        KingdomMenu.openRankSelection(player, target, () -> KingdomMenu.openPlayerInfo(player, target, back));
                        return true;
                    });
                }
            } else if (player.getUser().getKingdom() != null && player.getUser().getKingdom().isInviteOnly() && player.hasPermission("kingdom.invite")) {
                builder.withItem(ItemStackBuilder.of(Material.COOKIE).withName(KingdomMenu.text("menuPlayerInfoItemInvite")).withLore(KingdomMenu.text("menuPlayerInfoItemLoreInvite")).build(), (p, ct) -> ((BukkitPlayer)player).getPlayer().chat("/k invite " + target.getName()));
            }
            KingdomMenu.withBack(builder, back);
            BukkitInventory inv = builder.build();
            kdc.getPlugin().getScheduler().sync().execute(() -> player.openInventory(inv));
        });
    }

    public static void openKingdomInfo(PlatformPlayer player, Kingdom target) {
        KingdomMenu.openKingdomInfo(player, target, null);
    }

    static void openKingdomInfo(PlatformPlayer player, Kingdom target, Runnable back) {
        InventoryBuilder builder = InventoryBuilder.create().withTitle(ChatColor.DARK_GRAY + target.getName());
        builder.withItem(ItemStackBuilder.of(KingdomMenu.getKingdomItem(target)).withLore("", KingdomMenu.text("menuKingdomInfoItemLore")).build(), (p, ct) -> KingdomMenu.openKingdomEdit(player, target, () -> KingdomMenu.openKingdomInfo(player, target, back)));
        if (!target.getRanks().isEmpty()) {
            builder.withItem(ItemStackBuilder.of(Material.BOOK).withName(KingdomMenu.text("menuKingdomInfoItemRanks", target.getRanks().size() + "")).withLore(KingdomMenu.text("menuKingdomInfoItemLoreRanks")).build(), (p, cct) -> {
                if (player.hasPermission("kingdom.ranks.list.other") || player.getUser().getKingdom() == target && player.hasPermission("kingdom.ranks.list")) {
                    KingdomMenu.openKingdomRanksList(player, target, () -> KingdomMenu.openKingdomInfo(player, target, back));
                    return true;
                }
                return false;
            });
        }
        builder.withItem(ItemStackBuilder.of("GOLDEN_CHESTPLATE", "GOLD_CHESTPLATE").withName(KingdomMenu.text("menuKingdomInfoItemRelations")).withLore(KingdomMenu.text("menuKingdomInfoItemLoreRelations")).build(), (p, ct) -> KingdomMenu.openKingdomRelationsList(player, target, () -> KingdomMenu.openKingdomInfo(player, target, back)));
        builder.withItem(ItemStackBuilder.skull().withName(KingdomMenu.text("menuKingdomInfoItemMembers", target.getMemberCount() + "")).apply(target.getMemberCount() > 0, b -> b.withLore(KingdomMenu.text("menuKingdomInfoItemLoreMembers"))).build(), (p, ct) -> {
            if (target.getMemberCount() == 0) {
                return false;
            }
            KingdomMenu.openKingdomMembersList(player, target, () -> KingdomMenu.openKingdomInfo(player, target, back));
            return true;
        });
        if (player.getUser().getKingdom() == target || player.hasPermission("kingdom.spawn.other")) {
            builder.withItem(ItemStackBuilder.of("RED_BED", "BED").withName(KingdomMenu.text("menuKingdomInfoItemSpawn")).apply(b -> {
                if (target.getSpawn() != null) {
                    b.withLore("", ChatColor.GRAY + "X: " + (int)target.getSpawn().getX() + ", Y: " + (int)target.getSpawn().getY() + ", Z: " + (int)target.getSpawn().getZ());
                } else {
                    b.withLore(KingdomMenu.text("menuKingdomInfoItemLoreSpawnNotSet"));
                }
                if (player.hasPermission("kingdom.setspawn.other") || player.hasPermission("kingdom.setspawn") && player.getUser().getKingdom() == target) {
                    b.withLore("", KingdomMenu.text("menuKingdomInfoItemLoreSpawnTeleport"), KingdomMenu.text("menuKingdomInfoItemLoreSpawnChange"));
                } else if (player.hasPermission("kingdom.spawn") && target.getSpawn() != null) {
                    b.withLore("", KingdomMenu.text("menuKingdomInfoItemLoreSpawnTeleport"));
                }
            }).build(), (p, ct) -> {
                if (ct == InventoryClickType.RIGHT) {
                    if (player.hasPermission("kingdom.setspawn.other")) {
                        KingdomMenu.openConfirmMenu(player, KingdomMenu.text("menuChangeKingdomSpawnOtherConfirmTitle", target.getName()), () -> {
                            kdc.getCommandManager().dispatch(player, new String[]{"setspawn", target.getName()});
                            KingdomMenu.openKingdomInfo(player, target, back);
                        }, () -> KingdomMenu.openKingdomInfo(player, target, back));
                        return true;
                    }
                    if (player.hasPermission("kingdom.setspawn") && player.getUser().getKingdom() == target) {
                        KingdomMenu.openConfirmMenu(player, KingdomMenu.text("menuChangeKingdomSpawnConfirmTitle"), () -> {
                            kdc.getCommandManager().dispatch(player, new String[]{"setspawn"});
                            KingdomMenu.openKingdomInfo(player, target, back);
                        }, () -> KingdomMenu.openKingdomInfo(player, target, back));
                        return true;
                    }
                }
                if (target.getSpawn() == null) {
                    return false;
                }
                if (target.getSpawn() != null && player.hasPermission("kingdom.spawn.other")) {
                    kdc.getCommandManager().dispatch(player, new String[]{"spawn", target.getName()});
                    return true;
                }
                if (player.hasPermission("kingdom.spawn") && player.getUser().getKingdom() == target) {
                    kdc.getCommandManager().dispatch(player, new String[]{"spawn"});
                    return true;
                }
                return false;
            });
        }
        KingdomMenu.withBack(builder, back);
        player.openInventory(builder.build());
    }

    static boolean openKingdomEdit(PlatformPlayer player, Kingdom target, Runnable back) {
        InventoryBuilder builder = InventoryBuilder.create().withTitle(KingdomMenu.text("menuKingdomEditTitle"));
        boolean hasItem = false;
        if (player.hasPermission("kingdom.edit.item.other") || player.hasPermission("kingdom.edit.item") && player.getUser().getKingdom() == target) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.DIAMOND).withName(KingdomMenu.text("menuKingdomEditItemChangeItem")).withLore(KingdomMenu.text("menuKingdomEditItemLoreChangeItem")).build(), (p, ct) -> KingdomMenu.openKingdomSelectItem(player, target, () -> KingdomMenu.openKingdomEdit(player, target, back)));
        }
        if (player.hasPermission("kingdom.rename.other") || player.hasPermission("kingdom.rename") && player.getUser().getKingdom() == target) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.NAME_TAG).withName(KingdomMenu.text("menuKingdomEditItemRename")).withLore(KingdomMenu.text("menuKingdomEditItemLoreRename", ChatColor.WHITE + target.getName())).build(), (p, ct) -> {
                kdc.getMessages().send((PlatformSender)player, "menuKingdomEditRenameQuery", new String[0]);
                KingdomMenu.startChatQuery(player, value -> {
                    if (player.getUser().getKingdom() == target) {
                        kdc.getCommandManager().dispatch(player, new String[]{"rename", value});
                    } else {
                        kdc.getCommandManager().dispatch(player, new String[]{"rename", target.getName(), value});
                    }
                    KingdomMenu.openKingdomEdit(player, target, back);
                }, () -> KingdomMenu.openKingdomEdit(player, target, back));
            });
        }
        if (player.hasPermission("kingdom.edit.display.other") || player.hasPermission("kingdom.edit.display") && player.getUser().getKingdom() == target) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.PAPER).withName(KingdomMenu.text("menuKingdomEditItemChangeDisplay")).withLore(KingdomMenu.text("menuKingdomEditItemLoreChangeDisplay", KingdomMenu.colorify(target.getDisplay()))).build(), (p, ct) -> {
                kdc.getMessages().send((PlatformSender)player, "menuKingdomEditChangeDisplayQuery", new String[0]);
                KingdomMenu.startChatQuery(player, value -> {
                    if (player.getUser().getKingdom() == target) {
                        kdc.getCommandManager().dispatch(player, new String[]{"edit", "display", value});
                    } else {
                        kdc.getCommandManager().dispatch(player, new String[]{"edit", "display", target.getName(), value});
                    }
                    KingdomMenu.openKingdomEdit(player, target, back);
                }, () -> KingdomMenu.openKingdomEdit(player, target, back));
            });
        }
        if (player.hasPermission("kingdom.edit.prefix.other") || player.hasPermission("kingdom.edit.prefix") && player.getUser().getKingdom() == target) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.GOLD_INGOT).withName(KingdomMenu.text("menuKingdomEditItemChangePrefix")).withLore(KingdomMenu.text("menuKingdomEditItemLoreChangePrefix", KingdomMenu.colorify(target.getPrefix()))).build(), (p, ct) -> {
                kdc.getMessages().send((PlatformSender)player, "menuKingdomEditChangePrefixQuery", new String[0]);
                KingdomMenu.startChatQuery(player, value -> {
                    if (player.getUser().getKingdom() == target) {
                        kdc.getCommandManager().dispatch(player, new String[]{"edit", "prefix", value});
                    } else {
                        kdc.getCommandManager().dispatch(player, new String[]{"edit", "prefix", target.getName(), value});
                    }
                    KingdomMenu.openKingdomEdit(player, target, back);
                }, () -> KingdomMenu.openKingdomEdit(player, target, back));
            });
        }
        if (player.hasPermission("kingdom.edit.suffix.other") || player.hasPermission("kingdom.edit.suffix") && player.getUser().getKingdom() == target) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.IRON_INGOT).withName(KingdomMenu.text("menuKingdomEditItemChangeSuffix")).withLore(KingdomMenu.text("menuKingdomEditItemLoreChangeSuffix", KingdomMenu.colorify(target.getSuffix()))).build(), (p, ct) -> {
                kdc.getMessages().send((PlatformSender)player, "menuKingdomEditChangeSuffixQuery", new String[0]);
                KingdomMenu.startChatQuery(player, value -> {
                    if (player.getUser().getKingdom() == target) {
                        kdc.getCommandManager().dispatch(player, new String[]{"edit", "suffix", value});
                    } else {
                        kdc.getCommandManager().dispatch(player, new String[]{"edit", "suffix", target.getName(), value});
                    }
                    KingdomMenu.openKingdomEdit(player, target, back);
                }, () -> KingdomMenu.openKingdomEdit(player, target, back));
            });
        }
        if (player.hasPermission("kingdom.edit.max-members.other") || player.hasPermission("kingdom.edit.max-members") && player.getUser().getKingdom() == target) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.skull().withName(KingdomMenu.text("menuKingdomEditItemChangeMaxMembers")).apply(target.getMaxMembers() == 0, b -> b.withLore(KingdomMenu.text("menuKingdomEditItemLoreChangeMaxMembersUnlimited"))).apply(target.getMaxMembers() != 0, b -> b.withLore(KingdomMenu.text("menuKingdomEditItemLoreChangeMaxMembers", target.getMaxMembers() + ""))).build(), (p, ct) -> {
                int mm3 = target.getMaxMembers();
                if (ct == InventoryClickType.LEFT) {
                    ++mm3;
                } else if (ct == InventoryClickType.RIGHT) {
                    --mm3;
                } else {
                    return false;
                }
                if (player.getUser().getKingdom() == target) {
                    ((BukkitPlayer)player).getPlayer().chat("/k edit max-members " + mm3);
                } else {
                    ((BukkitPlayer)player).getPlayer().chat("/k edit max-members " + target.getName() + " " + mm3);
                }
                KingdomMenu.openKingdomEdit(player, target, back);
                return true;
            });
        }
        if (player.hasPermission("kingdom.edit.invite-only.other") || player.hasPermission("kingdom.edit.invite-only") && player.getUser().getKingdom() == target) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of("ENDER_EYE", "EYE_OF_ENDER").withName(KingdomMenu.text("menuKingdomEditItemToggleInviteOnly")).withLore(KingdomMenu.text("menuKingdomEditItemLoreToggleInviteOnly", target.isInviteOnly() + "")).build(), (p, ct) -> {
                if (player.getUser().getKingdom() == target) {
                    ((BukkitPlayer)player).getPlayer().chat("/k edit invite-only " + !target.isInviteOnly());
                } else {
                    ((BukkitPlayer)player).getPlayer().chat("/k edit invite-only " + target.getName() + " " + !target.isInviteOnly());
                }
                KingdomMenu.openKingdomEdit(player, target, back);
            });
        }
        if (!hasItem) {
            return false;
        }
        KingdomMenu.withBack(builder, back);
        player.openInventory(builder.build());
        return true;
    }

    private static String upperCaseWords(String str) {
        ArrayList<String> words = new ArrayList<String>();
        for (String word : str.split(Pattern.quote(" "))) {
            StringBuilder sb = new StringBuilder();
            sb.append(word.substring(0, 1).toUpperCase());
            if (word.length() > 1) {
                sb.append(word.substring(1).toLowerCase());
            }
            words.add(sb.toString());
        }
        return String.join((CharSequence)" ", words);
    }

    static void openKingdomSelectItem(PlatformPlayer player, Kingdom target, Runnable back) {
        PaginationBuilder builder = PaginationBuilder.create().withTitle(KingdomMenu.text("menuKingdomChangeItemTitle"));
        LinkedHashMap<ItemStack, String> items = new LinkedHashMap<ItemStack, String>();
        for (ItemStackBuilder.ItemColor color : ItemStackBuilder.ItemColor.values()) {
            items.put(ItemStackBuilder.wool(color).build(), KingdomMenu.upperCaseWords(color.name().replace("_", " ")) + " Wool");
        }
        for (ItemStackBuilder.ItemColor color : ItemStackBuilder.ItemColor.values()) {
            items.put(ItemStackBuilder.terracotta(color).build(), KingdomMenu.upperCaseWords(color.name().replace("_", " ")) + " Terracotta");
        }
        for (ItemStackBuilder.ItemColor color : ItemStackBuilder.ItemColor.values()) {
            items.put(ItemStackBuilder.glass(color).build(), KingdomMenu.upperCaseWords(color.name().replace("_", " ")) + " Glass");
        }
        items.put(ItemStackBuilder.of(Material.CHEST).build(), "Chest");
        items.put(ItemStackBuilder.of("STONE_BRICKS", "SMOOTH_BRICK").build(), "Stone Bricks");
        items.put(ItemStackBuilder.of("NETHER_BRICKS", "NETHER_BRICK").build(), "Nether Bricks");
        items.put(ItemStackBuilder.of("BRICKS", "BRICK").build(), "Bricks");
        items.put(ItemStackBuilder.of(Material.ICE).build(), "Ice");
        items.put(ItemStackBuilder.of(Material.SNOW_BLOCK).build(), "Ice");
        items.put(ItemStackBuilder.of("OAK_LOG", "LOG").build(), "Oak Log");
        items.put(ItemStackBuilder.of("SPRUCE_LOG", "LOG", 1).build(), "Spruce Log");
        items.put(ItemStackBuilder.of("BIRCH_LOG", "LOG", 2).build(), "Birch Log");
        items.put(ItemStackBuilder.of("JUNGLE_LOG", "LOG", 3).build(), "Jungle Log");
        items.put(ItemStackBuilder.of("DARK_OAK_LOG", "LOG_2", 1).build(), "Dark Oak Log");
        items.put(ItemStackBuilder.of("ACACIA_LOG", "LOG_2", 2).build(), "Acacia Log");
        items.put(ItemStackBuilder.of("CARVED_PUMPKIN", "PUMPKIN").build(), "Carved Pumpkin");
        items.put(ItemStackBuilder.of(Material.GLOWSTONE).build(), "Glowstone");
        items.put(ItemStackBuilder.of(Material.TNT).build(), "TNT");
        items.put(ItemStackBuilder.of(Material.BOOKSHELF).build(), "Bookshelf");
        items.put(ItemStackBuilder.of(Material.EMERALD_BLOCK).build(), "Emerald Block");
        items.put(ItemStackBuilder.of(Material.DIAMOND_BLOCK).build(), "Diamond Block");
        items.put(ItemStackBuilder.of(Material.IRON_BLOCK).build(), "Iron Block");
        items.put(ItemStackBuilder.of(Material.GOLD_BLOCK).build(), "Gold Block");
        items.put(ItemStackBuilder.of(Material.OBSIDIAN).build(), "Obsidian");
        items.put(ItemStackBuilder.of(Material.FURNACE).build(), "Furnace");
        items.put(ItemStackBuilder.of("CRAFTING_TABLE", "WORKBENCH").build(), "Crafting Table");
        items.put(ItemStackBuilder.of(Material.JUKEBOX).build(), "Jukebox");
        ArrayList<ItemStack> items2 = new ArrayList<ItemStack>();
        for (ItemStack item : items.keySet()) {
            items2.add(ItemStackBuilder.of(item.clone()).withName(ChatColor.YELLOW + (String)items.get(item)).build());
        }
        builder.withItems(items2.size(), index -> new BukkitInventoryItem((ItemStack)items2.get((int)index), (p, ct) -> {
            target.setItem(new BukkitItem((ItemStack)items2.get((int)index)));
            kdc.saveAsync(target);
            back.run();
            return true;
        }));
        KingdomMenu.withBack(builder, back);
        player.openInventory(builder.build());
    }

    static void openKingdomMembersList(PlatformPlayer player, Kingdom target, Runnable back) {
        kdc.getPlugin().getScheduler().async().execute(() -> {
            PaginationBuilder builder = PaginationBuilder.create().withTitle(KingdomMenu.text("menuKingdomMembersListTitle", target.getName()));
            Map<UUID, String> members = target.getMembers();
            List sorted = members.keySet().stream().sorted(Comparator.comparing(uuid -> kdc.getPlayer((UUID)uuid) == null)).collect(Collectors.toList());
            builder.withItems(sorted.size(), index -> {
                UUID uuid = (UUID)sorted.get((int)index);
                String name = (String)members.get(uuid);
                boolean isOnline = kdc.getPlayer(uuid) != null;
                return new BukkitInventoryItem(ItemStackBuilder.skull().withName(isOnline ? ChatColor.GREEN + name : ChatColor.GRAY + name).apply(isOnline, b -> b.withSkullOwner((OfflinePlayer)Bukkit.getPlayer((UUID)uuid))).build(), (p, ct) -> {
                    kdc.getUser(uuid).thenAccept(u -> kdc.getPlugin().getScheduler().sync().execute(() -> KingdomMenu.openPlayerInfo(player, u, () -> KingdomMenu.openKingdomMembersList(player, target, back))));
                    return true;
                });
            });
            KingdomMenu.withBack(builder, back);
            builder.buildAsync(player, kdc.getPlugin().getScheduler().sync(), kdc.getPlugin().getScheduler().async());
        });
    }

    static void openKingdomRanksList(PlatformPlayer player, Kingdom target, Runnable back) {
        PaginationBuilder builder = PaginationBuilder.create().withTitle(KingdomMenu.text("menuKingdomRanksListTitle", target.getName()));
        ArrayList<Rank> ranks = new ArrayList<Rank>(target.getRanks());
        builder.withItems(ranks.size(), index -> {
            Rank rank = (Rank)ranks.get((int)index);
            return new BukkitInventoryItem(ItemStackBuilder.of(KingdomMenu.getRankItem(rank)).withLore("", KingdomMenu.text("menuKingdomRanksListItemLore")).build(), (p, ct) -> KingdomMenu.openRankEdit(player, rank, () -> KingdomMenu.openKingdomRanksList(player, target, back)));
        });
        KingdomMenu.withBack(builder, back);
        player.openInventory(builder.build());
    }

    static boolean openRankEdit(PlatformPlayer player, Rank target, Runnable back) {
        InventoryBuilder builder = InventoryBuilder.create().withTitle(ChatColor.DARK_GRAY + "Edit rank");
        boolean hasItem = false;
        if (player.hasPermission("kingdom.ranks.rename.other") || player.hasPermission("kingdom.ranks.rename") && player.getUser().getKingdom() == target.getKingdom()) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.NAME_TAG).withName(KingdomMenu.text("menuRankEditItemRename")).withLore(KingdomMenu.text("menuRankEditItemLoreRename", target.getName())).build(), (p, ct) -> {
                kdc.getMessages().send((PlatformSender)player, "menuRankEditRenameQuery", new String[0]);
                KingdomMenu.startChatQuery(player, value -> {
                    if (player.getUser().getKingdom() == target.getKingdom()) {
                        kdc.getCommandManager().dispatch(player, new String[]{"ranks", "rename", target.getName(), value});
                    } else {
                        kdc.getCommandManager().dispatch(player, new String[]{"ranks", "rename", target.getKingdom().getName(), target.getName(), value});
                    }
                    KingdomMenu.openRankEdit(player, target, back);
                }, () -> KingdomMenu.openRankEdit(player, target, back));
            });
        }
        if (player.hasPermission("kingdom.ranks.edit.display.other") || player.hasPermission("kingdom.ranks.edit.display") && player.getUser().getKingdom() == target.getKingdom()) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.PAPER).withName(KingdomMenu.text("menuRankEditItemChangeDisplay")).withLore(KingdomMenu.text("menuRankEditItemLoreChangeDisplay", KingdomMenu.colorify(target.getDisplay()))).build(), (p, ct) -> {
                kdc.getMessages().send((PlatformSender)player, "menuRankEditChangeDisplayQuery", new String[0]);
                KingdomMenu.startChatQuery(player, value -> {
                    if (player.getUser().getKingdom() == target.getKingdom()) {
                        kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "display", target.getName(), value});
                    } else {
                        kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "display", target.getKingdom().getName(), target.getName(), value});
                    }
                    KingdomMenu.openRankEdit(player, target, back);
                }, () -> KingdomMenu.openRankEdit(player, target, back));
            });
        }
        if (player.hasPermission("kingdom.ranks.edit.prefix.other") || player.hasPermission("kingdom.ranks.edit.prefix") && player.getUser().getKingdom() == target.getKingdom()) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.GOLD_INGOT).withName(KingdomMenu.text("menuRankEditItemChangePrefix")).withLore(KingdomMenu.text("menuRankEditItemLoreChangePrefix", KingdomMenu.colorify(target.getPrefix()))).build(), (p, ct) -> {
                kdc.getMessages().send((PlatformSender)player, "menuRankEditChangePrefixQuery", new String[0]);
                KingdomMenu.startChatQuery(player, value -> {
                    if (player.getUser().getKingdom() == target.getKingdom()) {
                        kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "prefix", target.getName(), value});
                    } else {
                        kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "prefix", target.getKingdom().getName(), target.getName(), value});
                    }
                    KingdomMenu.openRankEdit(player, target, back);
                }, () -> KingdomMenu.openRankEdit(player, target, back));
            });
        }
        if (player.hasPermission("kingdom.ranks.edit.suffix.other") || player.hasPermission("kingdom.ranks.edit.suffix") && player.getUser().getKingdom() == target.getKingdom()) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.IRON_INGOT).withName(KingdomMenu.text("menuRankEditItemChangeSuffix")).withLore(KingdomMenu.text("menuRankEditItemLoreChangeSuffix", KingdomMenu.colorify(target.getSuffix()))).build(), (p, ct) -> {
                kdc.getMessages().send((PlatformSender)player, "menuRankEditChangeSuffixQuery", new String[0]);
                KingdomMenu.startChatQuery(player, value -> {
                    if (player.getUser().getKingdom() == target.getKingdom()) {
                        kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "suffix", target.getName(), value});
                    } else {
                        kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "suffix", target.getKingdom().getName(), target.getName(), value});
                    }
                    KingdomMenu.openRankEdit(player, target, back);
                }, () -> KingdomMenu.openRankEdit(player, target, back));
            });
        }
        if (player.hasPermission("kingdom.ranks.edit.max-members.other") || player.hasPermission("kingdom.ranks.edit.max-members") && player.getUser().getKingdom() == target.getKingdom()) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.skull().withName(KingdomMenu.text("menuRankEditItemChangeMaxMembers")).apply(target.getMaxMembers() == 0, b -> b.withLore(KingdomMenu.text("menuRankEditItemLoreChangeMaxMembersUnlimited"))).apply(target.getMaxMembers() != 0, b -> b.withLore(KingdomMenu.text("menuRankEditItemLoreChangeMaxMembers", target.getMaxMembers() + ""))).build(), (p, ct) -> {
                int mm3 = target.getMaxMembers();
                if (ct == InventoryClickType.LEFT) {
                    ++mm3;
                } else if (ct == InventoryClickType.RIGHT) {
                    --mm3;
                } else {
                    return false;
                }
                if (player.getUser().getKingdom() == target.getKingdom()) {
                    kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "max-members", target.getName(), mm3 + ""});
                } else {
                    kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "max-members", target.getKingdom().getName(), target.getName(), mm3 + ""});
                }
                KingdomMenu.openRankEdit(player, target, back);
                return true;
            });
        }
        if (player.hasPermission("kingdom.ranks.edit.level.other") || player.hasPermission("kingdom.ranks.edit.level") && player.getUser().getKingdom() == target.getKingdom()) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of(Material.BLAZE_ROD).withName(KingdomMenu.text("menuRankEditItemChangeLevel")).withLore(KingdomMenu.text("menuRankEditItemLoreChangeLevel", target.getLevel() + "")).build(), (p, ct) -> {
                int level = target.getLevel();
                if (ct == InventoryClickType.LEFT) {
                    ++level;
                } else if (ct == InventoryClickType.RIGHT) {
                    --level;
                } else {
                    return false;
                }
                if (player.getUser().getKingdom() == target.getKingdom()) {
                    kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "level", target.getName(), level + ""});
                } else {
                    kdc.getCommandManager().dispatch(player, new String[]{"ranks", "edit", "level", target.getKingdom().getName(), target.getName(), level + ""});
                }
                KingdomMenu.openRankEdit(player, target, back);
                return true;
            });
        }
        if (!hasItem) {
            return false;
        }
        KingdomMenu.withBack(builder, back);
        player.openInventory(builder.build());
        return true;
    }

    static void openRankSelection(PlatformPlayer player, User target, Runnable back) {
        PaginationBuilder builder = PaginationBuilder.create().withTitle(KingdomMenu.text("menuChangePlayerRankTitle", target.getName()));
        ArrayList<Rank> ranks = new ArrayList<Rank>();
        for (Rank rank : target.getKingdom().getRanks()) {
            if (rank == target.getRank() || !player.hasPermission("kingdom.setrank.other") && player.getUser().getKingdom() == target.getKingdom() && rank.getLevel() >= player.getUser().getRank().getLevel()) continue;
            ranks.add(rank);
        }
        builder.withItems(ranks.size(), index -> {
            Rank rank = (Rank)ranks.get((int)index);
            return new BukkitInventoryItem(KingdomMenu.getRankItem(rank), (p, ct) -> {
                KingdomMenu.openConfirmMenu(player, KingdomMenu.text("menuChangePlayerRankConfirmTitle", target.getName(), rank.getName()), () -> {
                    ((BukkitPlayer)player).getPlayer().chat("/k setrank " + target.getName() + " " + rank.getName());
                    KingdomMenu.openPlayerInfo(player, target, back);
                }, () -> KingdomMenu.openRankSelection(player, target, back));
                return true;
            });
        });
        KingdomMenu.withBack(builder, back);
        player.openInventory(builder.build());
    }

    static void openKingdomRelationsList(PlatformPlayer player, Kingdom kingdom, Runnable back) {
        PaginationBuilder builder = PaginationBuilder.create().withTitle(KingdomMenu.text("menuRelationsTitle", kingdom.getName()));
        Map<Kingdom, RelationType> relations = kdc.getRelations(kingdom).stream().collect(Collectors.toMap(rel -> rel.getOther(kingdom), Relation::getType));
        List kingdoms = relations.keySet().stream().sorted(Comparator.comparing(kd -> RELATION_ORDER.get(relations.get(kd)))).collect(Collectors.toList());
        kingdoms.addAll(kdc.getKingdoms().stream().filter(kd -> kd != kingdom && !kingdoms.contains(kd)).collect(Collectors.toSet()));
        builder.withItems(kingdoms.size(), index -> {
            Kingdom kd = (Kingdom)kingdoms.get((int)index);
            RelationType rel = relations.getOrDefault(kd, RelationType.NEUTRAL);
            ItemStack item = ItemStackBuilder.of(KingdomMenu.getKingdomItem(kd)).clearLore().withLore(ChatColor.GRAY + rel.name().substring(0, 1).toUpperCase() + rel.name().substring(1).toLowerCase()).build();
            if (kingdom == player.getUser().getKingdom()) {
                return new BukkitInventoryItem(item, (p, ct) -> KingdomMenu.openKingdomRelationSelect(player, kd, () -> KingdomMenu.openKingdomRelationsList(player, kingdom, back)));
            }
            return new BukkitInventoryItem(item);
        });
        KingdomMenu.withBack(builder, back);
        player.openInventory(builder.build());
    }

    static boolean openKingdomRelationSelect(PlatformPlayer player, Kingdom kingdom, Runnable back) {
        InventoryBuilder builder = InventoryBuilder.create().withTitle(KingdomMenu.text("menuChangeRelationTitle", kingdom.getName()));
        boolean hasItem = false;
        Relation relation = kdc.getRelation(player.getUser().getKingdom(), kingdom);
        RelationType rel = relation != null ? relation.getType() : RelationType.NEUTRAL;
        Relation receivedRequest = kdc.getRelationRequest(kingdom, player.getUser().getKingdom());
        Relation sentRequest = kdc.getRelationRequest(player.getUser().getKingdom(), kingdom);
        if (rel != RelationType.ALLY && player.hasPermission("kingdom.ally")) {
            hasItem = true;
            if (sentRequest != null && sentRequest.getType() == RelationType.ALLY) {
                builder.withItem(ItemStackBuilder.of(Material.SLIME_BALL).withName(ChatColor.WHITE + KingdomMenu.colorify(kingdom.getDisplay())).withLore(KingdomMenu.text("menuChangeRelationItemLoreAllyRequested")).build());
            } else {
                builder.withItem(ItemStackBuilder.of(Material.SLIME_BALL).withName(ChatColor.WHITE + KingdomMenu.colorify(kingdom.getDisplay())).apply(b -> {
                    if (receivedRequest != null && receivedRequest.getType() == RelationType.ALLY) {
                        b.withLore(KingdomMenu.text("menuChangeRelationItemLoreAllyAccept"));
                    } else {
                        b.withLore(KingdomMenu.text("menuChangeRelationItemLoreAllyRequest"));
                    }
                }).build(), (p, ct) -> {
                    kdc.getCommandManager().dispatch(player, new String[]{"ally", kingdom.getName()});
                    KingdomMenu.openKingdomRelationSelect(player, kingdom, back);
                });
            }
        }
        if (rel != RelationType.ENEMY && player.hasPermission("kingdom.enemy")) {
            hasItem = true;
            builder.withItem(ItemStackBuilder.of("FIRE_CHARGE", "FIREBALL").withName(ChatColor.WHITE + KingdomMenu.colorify(kingdom.getDisplay())).apply(b -> b.withLore(KingdomMenu.text("menuChangeRelationItemLoreEnemy"))).build(), (p, ct) -> {
                kdc.getCommandManager().dispatch(player, new String[]{"enemy", kingdom.getName()});
                KingdomMenu.openKingdomRelationSelect(player, kingdom, back);
            });
        }
        if (rel == RelationType.ENEMY && player.hasPermission("kingdom.truce")) {
            hasItem = true;
            if (sentRequest != null && sentRequest.getType() == RelationType.TRUCE) {
                builder.withItem(ItemStackBuilder.of(Material.MAGMA_CREAM).withName(ChatColor.WHITE + KingdomMenu.colorify(kingdom.getDisplay())).withLore(KingdomMenu.text("menuChangeRelationItemLoreTruceRequested")).build());
            } else {
                builder.withItem(ItemStackBuilder.of(Material.MAGMA_CREAM).withName(ChatColor.WHITE + KingdomMenu.colorify(kingdom.getDisplay())).apply(b -> {
                    if (receivedRequest != null && receivedRequest.getType() == RelationType.TRUCE) {
                        b.withLore(KingdomMenu.text("menuChangeRelationItemLoreTruceAccept"));
                    } else {
                        b.withLore(KingdomMenu.text("menuChangeRelationItemLoreTruceRequest"));
                    }
                }).build(), (p, ct) -> {
                    kdc.getCommandManager().dispatch(player, new String[]{"truce", kingdom.getName()});
                    KingdomMenu.openKingdomRelationSelect(player, kingdom, back);
                });
            }
        }
        if (rel != RelationType.NEUTRAL && player.hasPermission("kingdom.neutral")) {
            hasItem = true;
            if (sentRequest != null && sentRequest.getType() == RelationType.NEUTRAL) {
                builder.withItem(ItemStackBuilder.of("SNOWBALL", "SNOW_BALL").withName(ChatColor.WHITE + KingdomMenu.colorify(kingdom.getDisplay())).withLore(KingdomMenu.text("menuChangeRelationItemLoreNeutralRequested")).build());
            } else {
                builder.withItem(ItemStackBuilder.of("SNOWBALL", "SNOW_BALL").withName(ChatColor.WHITE + KingdomMenu.colorify(kingdom.getDisplay())).apply(b -> {
                    if (rel != RelationType.ALLY) {
                        if (receivedRequest != null && receivedRequest.getType() == RelationType.NEUTRAL) {
                            b.withLore(KingdomMenu.text("menuChangeRelationItemLoreNeutralAccept"));
                        } else {
                            b.withLore(KingdomMenu.text("menuChangeRelationItemLoreNeutralRequest"));
                        }
                    } else {
                        b.withLore(KingdomMenu.text("menuChangeRelationItemLoreNeutralEndAlliance"));
                    }
                }).build(), (p, ct) -> {
                    kdc.getCommandManager().dispatch(player, new String[]{"neutral", kingdom.getName()});
                    KingdomMenu.openKingdomRelationSelect(player, kingdom, back);
                });
            }
        }
        if (!hasItem) {
            return false;
        }
        KingdomMenu.withBack(builder, back);
        player.openInventory(builder.build());
        return true;
    }

    static void openConfirmMenu(PlatformPlayer player, String title, Runnable confirm, Runnable cancel) {
        BukkitInventory inv = new BukkitInventory(27, title);
        inv.setItem(11, ItemStackBuilder.of(Material.EMERALD_BLOCK).withName(KingdomMenu.text("menuConfirmAccept")).build(), (p, ct) -> {
            confirm.run();
            return true;
        });
        inv.setItem(15, ItemStackBuilder.of(Material.REDSTONE_BLOCK).withName(KingdomMenu.text("menuConfirmCancel")).build(), (p, ct) -> {
            cancel.run();
            return true;
        });
        player.openInventory(inv);
    }

    static ItemStack getRankItem(Rank rank) {
        return ItemStackBuilder.of(Material.BOOK).withName(ChatColor.WHITE + KingdomMenu.colorify(rank.getDisplay()) + (rank.getLevel() > 0 ? ChatColor.GRAY + " (" + ChatColor.GOLD + rank.getLevel() + ChatColor.GRAY + ")" : "")).withLore("").withLore(KingdomMenu.text("menuInfoOnlineMembers", kdc.getOnlineUsers().stream().filter(u -> u.getRank() == rank).count() + "", rank.getMemberCount() + "")).apply(b -> {
            if (rank.getMaxMembers() > 0) {
                b.withLore(KingdomMenu.text("menuInfoMaxMembers", rank.getMaxMembers() + ""));
            }
        }).build();
    }

    static ItemStack getKingdomItem(Kingdom kingdom) {
        ItemStackBuilder builder = kingdom.getItem() != null && kingdom.getItem().getHandle() != null ? ItemStackBuilder.of((ItemStack)kingdom.getItem().getHandle()) : ItemStackBuilder.of("WHITE_BANNER", "BANNER");
        return builder.withName(ChatColor.WHITE + KingdomMenu.colorify(kingdom.getDisplay())).withLore("").withLore(KingdomMenu.text("menuInfoOnlineMembers", kdc.getOnlineUsers().stream().filter(u -> u.getKingdom() == kingdom).count() + "", kingdom.getMemberCount() + "")).apply(b -> {
            if (kingdom.getMaxMembers() > 0) {
                b.withLore(KingdomMenu.text("menuInfoMaxMembers", kingdom.getMaxMembers() + ""));
            }
        }).withLore(KingdomMenu.text("menuInfoCreatedAt", kingdom.getCreatedAt().atZone(kdc.getConfig().getTimeZone()).format(kdc.getConfig().getDateFormat()))).build();
    }

    static void startChatQuery(PlatformPlayer player, Consumer<String> callback, Runnable cancel) {
        kdc.getMessages().send((PlatformSender)player, "menuQueryCancel", new String[0]);
        player.set("MENU_CHAT_CALLBACK", callback);
        player.set("MENU_CHAT_CANCEL", cancel);
        player.closeInventory();
    }

    static {
        RELATION_ORDER = new HashMap<RelationType, Integer>();
        RELATION_ORDER.put(RelationType.ALLY, 1);
        RELATION_ORDER.put(RelationType.TRUCE, 2);
        RELATION_ORDER.put(RelationType.ENEMY, 3);
        RELATION_ORDER.put(RelationType.NEUTRAL, 4);
    }
}

