/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.bukkit.menu;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.bukkit.menu.KingdomMenu;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class InfoCommand
extends CommandBase {
    public InfoCommand(KingdomCraftImpl kdc) {
        super(kdc, "info", -1, true);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdInfoExplanation"));
        this.setPermissions("kingdom.menu", "kingdom.info");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        List<String> result = this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        result.addAll(this.kdc.getOnlinePlayers().stream().filter(p -> p != player).map(PlatformPlayer::getName).collect(Collectors.toList()));
        return result;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer player = (PlatformPlayer)sender;
        User user = this.kdc.getUser(player);
        if (args.length == 0 || args[0].equalsIgnoreCase(player.getName())) {
            KingdomMenu.openPlayerInfo(player, user);
            return;
        }
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom != null) {
            KingdomMenu.openKingdomInfo(player, kingdom);
            return;
        }
        this.kdc.getPlugin().getScheduler().executeAsync(() -> {
            try {
                User target = this.kdc.getUser(args[0]).get();
                if (target == null) {
                    this.kdc.getMessages().send((PlatformSender)player, "cmdErrorPlayerNotExist", args[0]);
                    return;
                }
                this.kdc.getPlugin().getScheduler().executeSync(() -> KingdomMenu.openPlayerInfo(player, target));
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }
}

